/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.pdf.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jabref.model.pdf.search.SearchResult;

public final class PdfSearchResults {
    private final List<SearchResult> searchResults;

    public PdfSearchResults(List<SearchResult> search) {
        this.searchResults = Collections.unmodifiableList(search);
    }

    public PdfSearchResults() {
        this.searchResults = Collections.emptyList();
    }

    public List<SearchResult> getSortedByScore() {
        ArrayList<SearchResult> sortedList = new ArrayList<SearchResult>(this.searchResults);
        sortedList.sort((searchResult, t1) -> Float.compare(searchResult.getLuceneScore(), t1.getLuceneScore()));
        return Collections.unmodifiableList(sortedList);
    }

    public List<SearchResult> getSearchResults() {
        return this.searchResults;
    }

    public HashMap<String, List<SearchResult>> getSearchResultsByPath() {
        HashMap<String, List<SearchResult>> resultsByPath = new HashMap<String, List<SearchResult>>();
        for (SearchResult result : this.searchResults) {
            if (resultsByPath.containsKey(result.getPath())) {
                resultsByPath.get(result.getPath()).add(result);
                continue;
            }
            ArrayList<SearchResult> resultsForPath = new ArrayList<SearchResult>();
            resultsForPath.add(result);
            resultsByPath.put(result.getPath(), resultsForPath);
        }
        return resultsByPath;
    }

    public int numSearchResults() {
        return this.searchResults.size();
    }
}

