/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.pdf;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.Optional;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.jabref.model.pdf.FileAnnotationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAnnotation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAnnotation.class);
    private static final int ABBREVIATED_ANNOTATION_NAME_LENGTH = 45;
    private static final String DATE_TIME_STRING = "^D:\\d{14}$";
    private static final String DATE_TIME_STRING_WITH_TIME_ZONE = "^D:\\d{14}.+";
    private static final String ANNOTATION_DATE_FORMAT = "yyyyMMddHHmmss";
    private final String author;
    private final LocalDateTime timeModified;
    private final int page;
    private final String content;
    private final FileAnnotationType annotationType;
    private final Optional<FileAnnotation> linkedFileAnnotation;

    public FileAnnotation(String author, LocalDateTime timeModified, int pageNumber, String content, FileAnnotationType annotationType, Optional<FileAnnotation> linkedFileAnnotation) {
        this.author = author;
        this.timeModified = timeModified;
        this.page = pageNumber;
        this.content = this.parseContent(content);
        this.annotationType = annotationType;
        this.linkedFileAnnotation = linkedFileAnnotation;
    }

    public FileAnnotation(PDAnnotation annotation, int pageNumber) {
        this(annotation.getCOSObject().getString(COSName.T), FileAnnotation.extractModifiedTime(annotation.getModifiedDate()), pageNumber, annotation.getContents(), FileAnnotationType.parse(annotation), Optional.empty());
    }

    public FileAnnotation(PDAnnotation annotation, int pageNumber, FileAnnotation linkedFileAnnotation) {
        this(annotation.getCOSObject().getString(COSName.T), FileAnnotation.extractModifiedTime(annotation.getModifiedDate()), pageNumber, annotation.getContents(), FileAnnotationType.parse(annotation), Optional.of(linkedFileAnnotation));
    }

    public static LocalDateTime extractModifiedTime(String dateTimeString) {
        if (dateTimeString == null) {
            return LocalDateTime.now();
        }
        if (dateTimeString.matches(DATE_TIME_STRING_WITH_TIME_ZONE)) {
            dateTimeString = dateTimeString.substring(2, 16);
        } else if (dateTimeString.matches(DATE_TIME_STRING)) {
            dateTimeString = dateTimeString.substring(2);
        }
        try {
            return LocalDateTime.parse(dateTimeString, DateTimeFormatter.ofPattern(ANNOTATION_DATE_FORMAT));
        }
        catch (DateTimeParseException e) {
            LOGGER.info("Expected a parseable date string! However, this text could not be parsed: '%s'".formatted(dateTimeString));
            return LocalDateTime.now();
        }
    }

    private String parseContent(String content) {
        if (content == null) {
            return "";
        }
        String unreadableContent = "\u00fe\u00ff";
        if (content.trim().equals("\u00fe\u00ff")) {
            return "";
        }
        return content.trim();
    }

    private String abbreviateAnnotationName(String annotationName) {
        if (annotationName.length() > 45) {
            return annotationName.subSequence(0, 45).toString() + "...";
        }
        return annotationName;
    }

    public String toString() {
        return this.abbreviateAnnotationName(this.content);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileAnnotation that = (FileAnnotation)other;
        return Objects.equals((Object)this.annotationType, (Object)that.annotationType) && Objects.equals(this.author, that.author) && Objects.equals(this.content, that.content) && Objects.equals(this.page, that.page) && Objects.equals(this.linkedFileAnnotation, that.linkedFileAnnotation) && Objects.equals(this.timeModified, that.timeModified);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotationType, this.author, this.content, this.page, this.linkedFileAnnotation, this.timeModified});
    }

    public String getAuthor() {
        return this.author;
    }

    public LocalDateTime getTimeModified() {
        return this.timeModified;
    }

    public int getPage() {
        return this.page;
    }

    public String getContent() {
        return this.content;
    }

    public FileAnnotationType getAnnotationType() {
        return this.annotationType;
    }

    public boolean hasLinkedAnnotation() {
        return this.linkedFileAnnotation.isPresent();
    }

    public FileAnnotation getLinkedFileAnnotation() {
        return this.linkedFileAnnotation.get();
    }
}

