/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.uno.Any;
import java.util.Optional;
import org.jabref.model.openoffice.DocumentAnnotation;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoNameAccess;
import org.jabref.model.openoffice.uno.UnoNamed;

public class UnoTextSection {
    public static XNameAccess getNameAccess(XTextDocument doc) throws NoDocumentException {
        XTextSectionsSupplier supplier = UnoCast.cast(XTextSectionsSupplier.class, doc).get();
        try {
            return supplier.getTextSections();
        }
        catch (DisposedException ex) {
            throw new NoDocumentException("UnoTextSection.getNameAccess failed with" + String.valueOf((Object)ex));
        }
    }

    public static Optional<XTextSection> getByName(XTextDocument doc, String name) throws WrappedTargetException, NoDocumentException {
        XNameAccess nameAccess = UnoTextSection.getNameAccess(doc);
        try {
            return Optional.ofNullable((XTextSection)((Any)nameAccess.getByName(name)).getObject());
        }
        catch (NoSuchElementException ex) {
            return Optional.empty();
        }
    }

    public static Optional<XTextRange> getAnchor(XTextDocument doc, String name) throws WrappedTargetException, NoDocumentException {
        XNameAccess nameAccess = UnoTextSection.getNameAccess(doc);
        return UnoNameAccess.getTextContentByName(nameAccess, name).map(XTextContent::getAnchor);
    }

    public static XNamed create(DocumentAnnotation documentAnnotation) throws CreationException {
        return UnoNamed.insertNamedTextContent("com.sun.star.text.TextSection", documentAnnotation);
    }
}

