/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.style;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.Citation;
import org.jabref.model.openoffice.style.CitationGroups;
import org.jabref.model.openoffice.style.CitationLookupResult;
import org.jabref.model.openoffice.style.CitationMarkerNormEntry;
import org.jabref.model.openoffice.style.CitationMarkerNumericBibEntry;
import org.jabref.model.openoffice.style.CitationPath;
import org.jabref.model.openoffice.style.ComparableCitedKey;

public class CitedKey
implements ComparableCitedKey,
CitationMarkerNormEntry,
CitationMarkerNumericBibEntry {
    public final String citationKey;
    private final List<CitationPath> where;
    private Optional<CitationLookupResult> db;
    private Optional<Integer> number;
    private Optional<String> uniqueLetter;
    private Optional<OOText> normCitMarker;

    CitedKey(String citationKey, CitationPath path, Citation citation) {
        this.citationKey = citationKey;
        this.where = new ArrayList<CitationPath>();
        this.where.add(path);
        this.db = citation.getLookupResult();
        this.number = citation.getNumber();
        this.uniqueLetter = citation.getUniqueLetter();
        this.normCitMarker = Optional.empty();
    }

    @Override
    public String getCitationKey() {
        return this.citationKey;
    }

    @Override
    public Optional<BibEntry> getBibEntry() {
        return this.db.map(e -> e.entry);
    }

    @Override
    public Optional<CitationLookupResult> getLookupResult() {
        return this.db;
    }

    @Override
    public Optional<Integer> getNumber() {
        return this.number;
    }

    public void setNumber(Optional<Integer> number) {
        this.number = number;
    }

    public List<CitationPath> getCitationPaths() {
        return new ArrayList<CitationPath>(this.where);
    }

    public Optional<String> getUniqueLetter() {
        return this.uniqueLetter;
    }

    public void setUniqueLetter(Optional<String> uniqueLetter) {
        this.uniqueLetter = uniqueLetter;
    }

    public Optional<OOText> getNormalizedCitationMarker() {
        return this.normCitMarker;
    }

    public void setNormalizedCitationMarker(Optional<OOText> normCitMarker) {
        this.normCitMarker = normCitMarker;
    }

    void addPath(CitationPath path, Citation cit) {
        this.where.add(path);
        if (!cit.getLookupResult().equals(this.db)) {
            throw new IllegalStateException("CitedKey.addPath: mismatch on cit.db");
        }
        if (!cit.getNumber().equals(this.number)) {
            throw new IllegalStateException("CitedKey.addPath: mismatch on cit.number");
        }
        if (!cit.getUniqueLetter().equals(this.uniqueLetter)) {
            throw new IllegalStateException("CitedKey.addPath: mismatch on cit.uniqueLetter");
        }
    }

    void lookupInDatabases(List<BibDatabase> databases) {
        this.db = Citation.lookup(databases, this.citationKey);
    }

    void distributeLookupResult(CitationGroups citationGroups) {
        citationGroups.distributeToCitations(this.where, Citation::setLookupResult, this.db);
    }

    void distributeNumber(CitationGroups citationGroups) {
        citationGroups.distributeToCitations(this.where, Citation::setNumber, this.number);
    }

    void distributeUniqueLetter(CitationGroups citationGroups) {
        citationGroups.distributeToCitations(this.where, Citation::setUniqueLetter, this.uniqueLetter);
    }
}

