/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.rangesort;

import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import java.util.ArrayList;
import java.util.List;
import org.jabref.model.openoffice.rangesort.RangeHolder;
import org.jabref.model.openoffice.rangesort.RangeOverlap;
import org.jabref.model.openoffice.rangesort.RangeOverlapKind;
import org.jabref.model.openoffice.rangesort.RangeSort;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoTextRange;

public class RangeOverlapWithin {
    private RangeOverlapWithin() {
    }

    public static <V extends RangeHolder> List<RangeOverlap<V>> findOverlappingRanges(XTextDocument doc, List<V> rangeHolders, boolean includeTouching, int reportAtMost) {
        RangeSort.RangePartitions<V> partitions = RangeSort.partitionAndSortRanges(rangeHolders);
        return RangeOverlapWithin.findOverlappingRanges(partitions, reportAtMost, includeTouching);
    }

    public static <V extends RangeHolder> List<RangeOverlap<V>> findOverlappingRanges(RangeSort.RangePartitions<V> input, int atMost, boolean includeTouching) {
        assert (atMost >= 0);
        ArrayList<RangeOverlap<V>> result = new ArrayList<RangeOverlap<V>>();
        for (List<V> partition : input.getPartitions()) {
            if (partition.isEmpty()) continue;
            XTextRangeCompare cmp = UnoCast.cast(XTextRangeCompare.class, ((RangeHolder)partition.getFirst()).getRange().getText()).get();
            for (int i = 0; i < partition.size() - 1; ++i) {
                XTextRange bRange;
                RangeHolder aHolder = (RangeHolder)partition.get(i);
                RangeHolder bHolder = (RangeHolder)partition.get(i + 1);
                XTextRange aRange = aHolder.getRange();
                int cmpResult = UnoTextRange.compareStartsThenEndsUnsafe(cmp, aRange, bRange = bHolder.getRange());
                if (cmpResult == 0) {
                    ArrayList<RangeHolder> aValues = new ArrayList<RangeHolder>();
                    aValues.add(aHolder);
                    while (i < partition.size() - 1 && UnoTextRange.compareStartsThenEndsUnsafe(cmp, aRange, ((RangeHolder)partition.get(i + 1)).getRange()) == 0) {
                        bHolder = (RangeHolder)partition.get(i + 1);
                        aValues.add(bHolder);
                        ++i;
                    }
                    result.add(new RangeOverlap(RangeOverlapKind.EQUAL_RANGE, aValues));
                    if (atMost <= 0 || result.size() < atMost) continue;
                    return result;
                }
                cmpResult = UnoTextRange.compareStartsUnsafe(cmp, aRange.getEnd(), bRange.getStart());
                if (cmpResult > 0 || includeTouching && cmpResult == 0) {
                    ArrayList<RangeHolder> valuesForOverlappingRanges = new ArrayList<RangeHolder>();
                    valuesForOverlappingRanges.add(aHolder);
                    valuesForOverlappingRanges.add(bHolder);
                    result.add(new RangeOverlap(cmpResult == 0 ? RangeOverlapKind.TOUCH : RangeOverlapKind.OVERLAP, valuesForOverlappingRanges));
                }
                if (atMost <= 0 || result.size() < atMost) continue;
                return result;
            }
        }
        return result;
    }
}

