/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.rangesort;

import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.uno.RuntimeException;
import java.util.Arrays;
import java.util.Objects;
import org.jabref.model.openoffice.uno.UnoCursor;
import org.jabref.model.openoffice.uno.UnoSelection;
import org.jabref.model.openoffice.util.OOResult;

public class FunctionalTextViewCursor {
    private final XTextRange initialPosition;
    private final XServiceInfo initialSelection;
    private final XTextViewCursor viewCursor;

    private FunctionalTextViewCursor(XTextRange initialPosition, XServiceInfo initialSelection, XTextViewCursor viewCursor) {
        this.initialPosition = initialPosition;
        this.initialSelection = initialSelection;
        this.viewCursor = viewCursor;
    }

    public static OOResult<FunctionalTextViewCursor, String> get(XTextDocument doc) {
        Objects.requireNonNull(doc);
        XTextCursor initialPosition = null;
        XServiceInfo initialSelection = UnoSelection.getSelectionAsXServiceInfo(doc).orElse(null);
        XTextViewCursor viewCursor = UnoCursor.getViewCursor(doc).orElse(null);
        if (viewCursor != null) {
            try {
                initialPosition = UnoCursor.createTextCursorByRange((XTextRange)viewCursor);
                viewCursor.getStart();
                return OOResult.ok(new FunctionalTextViewCursor((XTextRange)initialPosition, initialSelection, viewCursor));
            }
            catch (RuntimeException ex) {
                viewCursor = null;
                initialPosition = null;
            }
        }
        if (initialSelection == null) {
            String errorMessage = "Selection is not available: cannot provide a functional view cursor";
            return OOResult.error(errorMessage);
        }
        if (Arrays.stream(initialSelection.getSupportedServiceNames()).noneMatch("com.sun.star.text.TextRanges"::equals)) {
            XTextRange newSelection = doc.getText().getStart();
            UnoSelection.select(doc, newSelection);
            viewCursor = UnoCursor.getViewCursor(doc).orElse(null);
        }
        if (viewCursor == null) {
            FunctionalTextViewCursor.restore(doc, (XTextRange)initialPosition, initialSelection);
            String errorMessage = "Could not get the view cursor";
            return OOResult.error(errorMessage);
        }
        try {
            viewCursor.getStart();
        }
        catch (RuntimeException ex) {
            FunctionalTextViewCursor.restore(doc, (XTextRange)initialPosition, initialSelection);
            String errorMessage = "The view cursor failed the functionality test";
            return OOResult.error(errorMessage);
        }
        return OOResult.ok(new FunctionalTextViewCursor((XTextRange)initialPosition, initialSelection, viewCursor));
    }

    public XTextViewCursor getViewCursor() {
        return this.viewCursor;
    }

    private static void restore(XTextDocument doc, XTextRange initialPosition, XServiceInfo initialSelection) {
        XTextViewCursor viewCursor;
        if (initialPosition != null && (viewCursor = (XTextViewCursor)UnoCursor.getViewCursor(doc).orElse(null)) != null) {
            viewCursor.gotoRange(initialPosition, false);
            return;
        }
        if (initialSelection != null) {
            UnoSelection.select(doc, initialSelection);
        }
    }

    public void restore(XTextDocument doc) {
        FunctionalTextViewCursor.restore(doc, this.initialPosition, this.initialSelection);
    }
}

