/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.metadata;

import java.util.List;
import org.jabref.model.metadata.SaveOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfContainedSaveOrder
extends SaveOrder {
    public static final Logger LOGGER = LoggerFactory.getLogger(SelfContainedSaveOrder.class);

    public SelfContainedSaveOrder(SaveOrder.OrderType orderType, List<SaveOrder.SortCriterion> sortCriteria) {
        super(orderType, sortCriteria);
        if (orderType == SaveOrder.OrderType.TABLE) {
            LOGGER.debug("TABLE with sort criteria {}", sortCriteria);
            throw new IllegalArgumentException("TABLE might require external lookup.");
        }
    }

    public static SelfContainedSaveOrder of(SaveOrder saveOrder) {
        if (saveOrder instanceof SelfContainedSaveOrder) {
            SelfContainedSaveOrder order = (SelfContainedSaveOrder)saveOrder;
            return order;
        }
        if (saveOrder.getOrderType() == SaveOrder.OrderType.TABLE && !saveOrder.getSortCriteria().isEmpty()) {
            return new SelfContainedSaveOrder(SaveOrder.OrderType.SPECIFIED, saveOrder.getSortCriteria());
        }
        return new SelfContainedSaveOrder(saveOrder.getOrderType(), saveOrder.getSortCriteria());
    }
}

