/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jabref.model.entry.field.Field;

public class ContentSelector {
    private final Field field;
    private final List<String> values;

    public ContentSelector(Field field, String ... values) {
        this(field, Arrays.asList(values));
    }

    public ContentSelector(Field field, List<String> values) {
        this.field = field;
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentSelector that = (ContentSelector)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.values, that.values);
    }

    public String toString() {
        return "ContentSelector [field=" + String.valueOf(this.field) + ", values=" + String.valueOf(this.values) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.field, this.values);
    }

    public Field getField() {
        return this.field;
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }
}

