/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.logic.auxparser.AuxParser;
import org.jabref.logic.auxparser.AuxParserResult;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.util.DummyFileUpdateMonitor;
import org.jabref.model.util.FileUpdateListener;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseLogic(value="because it needs access to aux parser")
public class TexGroup
extends AbstractGroup
implements FileUpdateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TexGroup.class);
    private final Path filePath;
    private Set<String> keysUsedInAux;
    private final FileUpdateMonitor fileMonitor;
    private final AuxParser auxParser;
    private final MetaData metaData;
    private final String user;

    TexGroup(String name, GroupHierarchyType context, Path filePath, AuxParser auxParser, FileUpdateMonitor fileMonitor, MetaData metaData, String user) {
        super(name, context);
        this.metaData = metaData;
        this.user = user;
        this.filePath = this.expandPath(Objects.requireNonNull(filePath));
        this.auxParser = auxParser;
        this.fileMonitor = fileMonitor;
    }

    TexGroup(String name, GroupHierarchyType context, Path filePath, AuxParser auxParser, FileUpdateMonitor fileMonitor, MetaData metaData) throws IOException {
        this(name, context, filePath, auxParser, fileMonitor, metaData, System.getProperty("user.name") + "-" + InetAddress.getLocalHost().getHostName());
    }

    public static TexGroup create(String name, GroupHierarchyType context, Path filePath, AuxParser auxParser, FileUpdateMonitor fileMonitor, MetaData metaData) throws IOException {
        TexGroup group = new TexGroup(name, context, filePath, auxParser, fileMonitor, metaData);
        fileMonitor.addListenerForFile(group.getFilePathResolved(), group);
        return group;
    }

    public static TexGroup create(String name, GroupHierarchyType context, Path filePath, AuxParser auxParser, MetaData metaData) throws IOException {
        return new TexGroup(name, context, filePath, auxParser, new DummyFileUpdateMonitor(), metaData);
    }

    public Path getFilePathResolved() {
        return this.filePath;
    }

    @Override
    public boolean contains(BibEntry entry) {
        if (this.keysUsedInAux == null) {
            AuxParserResult auxResult = this.auxParser.parse(this.filePath);
            this.keysUsedInAux = auxResult.getUniqueKeys();
        }
        return entry.getCitationKey().map(this.keysUsedInAux::contains).orElse(false);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public AbstractGroup deepCopy() {
        try {
            return new TexGroup(this.name.getValue(), this.context, this.filePath, this.auxParser, this.fileMonitor, this.metaData);
        }
        catch (IOException ex) {
            LOGGER.error("Problem creating copy of group", (Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TexGroup group = (TexGroup)o;
        return Objects.equals(this.filePath, group.filePath);
    }

    @Override
    public String toString() {
        return "TexGroup{filePath=" + String.valueOf(this.filePath) + ", keysUsedInAux=" + String.valueOf(this.keysUsedInAux) + ", auxParser=" + String.valueOf(this.auxParser) + ", fileMonitor=" + String.valueOf(this.fileMonitor) + "} " + super.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filePath);
    }

    public Path getFilePath() {
        return this.relativize(this.filePath);
    }

    @Override
    public void fileUpdated() {
        this.keysUsedInAux = null;
        this.metaData.groupsBinding().invalidate();
    }

    private Path relativize(Path path) {
        List<Path> fileDirectories = this.getFileDirectoriesAsPaths();
        return FileUtil.relativize(path, fileDirectories);
    }

    private Path expandPath(Path path) {
        List<Path> fileDirectories = this.getFileDirectoriesAsPaths();
        return FileUtil.find(path.toString(), fileDirectories).orElse(path);
    }

    private List<Path> getFileDirectoriesAsPaths() {
        return this.metaData.getLatexFileDirectory(this.user).map(List::of).orElse(Collections.emptyList());
    }
}

