/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.KeywordGroup;
import org.jabref.model.strings.LatexToUnicodeAdapter;

public class LastNameGroup
extends KeywordGroup {
    public LastNameGroup(String groupName, GroupHierarchyType context, Field searchField, String lastName) {
        super(groupName, context, searchField, LatexToUnicodeAdapter.format(lastName), true);
    }

    static List<String> getAsLastNamesLatexFree(Field field, BibEntry bibEntry) {
        return bibEntry.getField(field).stream().map(AuthorList::parse).map(AuthorList::latexFree).map(AuthorList::getAuthors).flatMap(Collection::stream).map(Author::getFamilyName).flatMap(Optional::stream).collect(Collectors.toList());
    }

    @Override
    public boolean contains(BibEntry entry) {
        return LastNameGroup.getAsLastNamesLatexFree(this.getSearchField(), entry).stream().anyMatch(name -> name.equals(this.getSearchExpression()));
    }

    @Override
    public AbstractGroup deepCopy() {
        return new LastNameGroup(this.getName(), this.getHierarchicalContext(), this.getSearchField(), this.getSearchExpression());
    }
}

