/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.types;

import java.util.Arrays;
import java.util.List;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypeBuilder;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.StandardEntryType;

public class BibtexEntryTypeDefinitions {
    private static final BibEntryType ARTICLE = new BibEntryTypeBuilder().withType(StandardEntryType.Article).withRequiredFields(StandardField.AUTHOR, StandardField.TITLE, StandardField.JOURNAL, StandardField.YEAR).withImportantFields(StandardField.VOLUME, StandardField.NUMBER, StandardField.PAGES, StandardField.MONTH, StandardField.ISSN, StandardField.NOTE).build();
    private static final BibEntryType BOOK = new BibEntryTypeBuilder().withType(StandardEntryType.Book).withRequiredFields(new OrFields(StandardField.AUTHOR, StandardField.EDITOR), StandardField.TITLE, StandardField.PUBLISHER, StandardField.YEAR).withImportantFields(StandardField.VOLUME, StandardField.NUMBER, StandardField.SERIES, StandardField.ADDRESS, StandardField.EDITION, StandardField.MONTH, StandardField.ISBN, StandardField.NOTE).build();
    private static final BibEntryType BOOKLET = new BibEntryTypeBuilder().withType(StandardEntryType.Booklet).withRequiredFields(StandardField.TITLE).withImportantFields(StandardField.AUTHOR, StandardField.HOWPUBLISHED, StandardField.ADDRESS, StandardField.MONTH, StandardField.YEAR, StandardField.NOTE).build();
    private static final BibEntryType CONFERENCE = new BibEntryTypeBuilder().withType(StandardEntryType.Conference).withRequiredFields(StandardField.AUTHOR, StandardField.TITLE, StandardField.BOOKTITLE, StandardField.YEAR).withImportantFields(StandardField.EDITOR, StandardField.VOLUME, StandardField.NUMBER, StandardField.SERIES, StandardField.PAGES, StandardField.ADDRESS, StandardField.MONTH, StandardField.ORGANIZATION, StandardField.PUBLISHER, StandardField.NOTE).build();
    private static final BibEntryType INBOOK = new BibEntryTypeBuilder().withType(StandardEntryType.InBook).addRequiredFields(new OrFields(StandardField.AUTHOR, StandardField.EDITOR)).addRequiredFields(StandardField.TITLE, StandardField.PUBLISHER, StandardField.YEAR).addRequiredFields(new OrFields(StandardField.CHAPTER, StandardField.PAGES)).withImportantFields(StandardField.VOLUME, StandardField.NUMBER, StandardField.SERIES, StandardField.TYPE, StandardField.ADDRESS, StandardField.EDITION, StandardField.MONTH, StandardField.ISBN, StandardField.NOTE).build();
    private static final BibEntryType INCOLLECTION = new BibEntryTypeBuilder().withType(StandardEntryType.InCollection).withRequiredFields(StandardField.AUTHOR, StandardField.TITLE, StandardField.BOOKTITLE, StandardField.PUBLISHER, StandardField.YEAR).withImportantFields(StandardField.EDITOR, StandardField.VOLUME, StandardField.NUMBER, StandardField.SERIES, StandardField.TYPE, StandardField.CHAPTER, StandardField.PAGES, StandardField.ADDRESS, StandardField.EDITION, StandardField.MONTH, StandardField.ISBN, StandardField.NOTE).build();
    private static final BibEntryType INPROCEEDINGS = new BibEntryTypeBuilder().withType(StandardEntryType.InProceedings).withRequiredFields(StandardField.AUTHOR, StandardField.TITLE, StandardField.BOOKTITLE, StandardField.YEAR).withImportantFields(StandardField.EDITOR, StandardField.VOLUME, StandardField.NUMBER, StandardField.SERIES, StandardField.PAGES, StandardField.ADDRESS, StandardField.MONTH, StandardField.ORGANIZATION, StandardField.PUBLISHER, StandardField.NOTE).build();
    private static final BibEntryType MANUAL = new BibEntryTypeBuilder().withRequiredFields(StandardField.TITLE).withImportantFields(StandardField.AUTHOR, StandardField.ORGANIZATION, StandardField.ADDRESS, StandardField.EDITION, StandardField.MONTH, StandardField.YEAR, StandardField.ISBN, StandardField.NOTE).withType(StandardEntryType.Manual).build();
    private static final BibEntryType MASTERSTHESIS = new BibEntryTypeBuilder().withType(StandardEntryType.MastersThesis).withRequiredFields(StandardField.AUTHOR, StandardField.TITLE, StandardField.SCHOOL, StandardField.YEAR).withImportantFields(StandardField.TYPE, StandardField.ADDRESS, StandardField.MONTH, StandardField.NOTE).build();
    private static final BibEntryType MISC = new BibEntryTypeBuilder().withType(StandardEntryType.Misc).withImportantFields(StandardField.AUTHOR, StandardField.TITLE, StandardField.HOWPUBLISHED, StandardField.MONTH, StandardField.YEAR, StandardField.NOTE).build();
    private static final BibEntryType PHDTHESIS = new BibEntryTypeBuilder().withType(StandardEntryType.PhdThesis).withRequiredFields(StandardField.AUTHOR, StandardField.TITLE, StandardField.SCHOOL, StandardField.YEAR).withImportantFields(StandardField.TYPE, StandardField.ADDRESS, StandardField.MONTH, StandardField.NOTE).build();
    private static final BibEntryType PROCEEDINGS = new BibEntryTypeBuilder().withType(StandardEntryType.Proceedings).withRequiredFields(StandardField.TITLE, StandardField.YEAR).withImportantFields(StandardField.EDITOR, StandardField.VOLUME, StandardField.NUMBER, StandardField.SERIES, StandardField.ADDRESS, StandardField.PUBLISHER, StandardField.MONTH, StandardField.ORGANIZATION, StandardField.ISBN, StandardField.NOTE).build();
    private static final BibEntryType TECHREPORT = new BibEntryTypeBuilder().withType(StandardEntryType.TechReport).withRequiredFields(StandardField.AUTHOR, StandardField.TITLE, StandardField.INSTITUTION, StandardField.YEAR).withImportantFields(StandardField.TYPE, StandardField.NUMBER, StandardField.ADDRESS, StandardField.MONTH, StandardField.NOTE).build();
    private static final BibEntryType UNPUBLISHED = new BibEntryTypeBuilder().withType(StandardEntryType.Unpublished).withRequiredFields(StandardField.AUTHOR, StandardField.TITLE, StandardField.NOTE).withImportantFields(StandardField.MONTH, StandardField.YEAR).build();
    public static final List<BibEntryType> ALL = Arrays.asList(ARTICLE, INBOOK, BOOK, BOOKLET, INCOLLECTION, CONFERENCE, INPROCEEDINGS, PROCEEDINGS, MANUAL, MASTERSTHESIS, PHDTHESIS, TECHREPORT, UNPUBLISHED, MISC);
    public static final List<BibEntryType> RECOMMENDED = Arrays.asList(ARTICLE, BOOK, INPROCEEDINGS, TECHREPORT, MISC);

    private BibtexEntryTypeDefinitions() {
    }
}

