/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.Identifier;
import org.jabref.model.strings.StringUtil;

public class MathSciNetId
implements Identifier {
    private String identifier;

    public MathSciNetId(String identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public static Optional<MathSciNetId> parse(String mrNumberRaw) {
        String identifier = StringUtil.tokenizeToList(mrNumberRaw, " (").getFirst().trim();
        return Optional.of(new MathSciNetId(identifier));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MathSciNetId that = (MathSciNetId)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public String toString() {
        return this.identifier;
    }

    @Override
    public Optional<URI> getExternalURI() {
        try {
            return Optional.of(new URI("https://www.ams.org/mathscinet-getitem?mr=" + this.identifier));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    @Override
    public Field getDefaultField() {
        return StandardField.MR_NUMBER;
    }

    @Override
    public String getNormalized() {
        return this.identifier;
    }
}

