/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.Identifier;

public class ISSN
implements Identifier {
    private static final Pattern ISSN_PATTERN = Pattern.compile("^\\d{4}-\\d{3}[\\dxX]$");
    private static final Pattern ISSN_PATTERN_NODASH = Pattern.compile("^(\\d{4})(\\d{3}[\\dxX])$");
    private final String issnString;

    public ISSN(String issnString) {
        this.issnString = Objects.requireNonNull(issnString).trim();
    }

    public boolean isValidFormat() {
        Matcher issnMatcher = ISSN_PATTERN.matcher(this.issnString);
        return issnMatcher.matches();
    }

    public boolean isCanBeCleaned() {
        Matcher issnNoDashMatcher = ISSN_PATTERN_NODASH.matcher(this.issnString);
        return issnNoDashMatcher.matches();
    }

    public String getCleanedISSN() {
        Matcher issnNoDashMatcher = ISSN_PATTERN_NODASH.matcher(this.issnString);
        if (issnNoDashMatcher.find()) {
            return issnNoDashMatcher.replaceFirst("$1-$2");
        }
        return this.issnString;
    }

    public boolean isValidChecksum() {
        int sum = 0;
        for (int pos = 0; pos <= 7; ++pos) {
            char c = this.issnString.charAt(pos);
            if (pos == 4) continue;
            sum += (c - 48) * (8 - pos + (pos > 4 ? 1 : 0));
        }
        int control = this.issnString.charAt(8);
        if (control == 120 || control == 88) {
            control = 58;
        }
        return sum % 11 + control - 48 == 11 || sum % 11 == 0;
    }

    @Override
    public String getNormalized() {
        return this.issnString;
    }

    @Override
    public Field getDefaultField() {
        return StandardField.ISSN;
    }

    @Override
    public Optional<URI> getExternalURI() {
        return Optional.empty();
    }
}

