/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseLogic(value="because we want to have this class 'smart' an be able to parse obscure DOIs, too. For this, we need the LatexToUnicodeformatter.")
public class DOI
implements Identifier {
    public static final URI AGENCY_RESOLVER = URI.create("https://doi.org/doiRA");
    public static final URI RESOLVER = URI.create("https://doi.org/");
    private static final Logger LOGGER = LoggerFactory.getLogger(DOI.class);
    private static final String DOI_EXP = "(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:%](?:.+))";
    private static final String FIND_DOI_EXP = "(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:](?:[^\\s,]+[^,;(\\.\\s)]))";
    private static final String SHORT_DOI_SHORTCUT = "^\\s*(?:https?://)?(?:www\\.)?(?:doi\\.org/)([a-z0-9]{4,10})\\s*$";
    private static final String IN_TEXT_SHORT_DOI_SHORTCUT = "(?:https?://)?(?:www\\.)?(?:doi\\.org/)([a-z0-9]{4,10})";
    private static final String SHORT_DOI_EXP_PREFIX = "^(?:\\s*(?:https?://)?(?:www\\.)?[a-zA-Z\\.]*doi[a-zA-Z\\.]*\\.[a-zA-Z]{2,10}/)?";
    private static final String SHORT_DOI_EXP = "(?:(?:[\\s/]?(?:(?:urn:)|(?:doi:)|(?:urn:doi:)))|(?:\\s?/?))(10[/%:][a-zA-Z0-9]{3,})\\s*$";
    private static final String FIND_SHORT_DOI_EXP = "(?:(?:(?:www\\.)?doi\\.org/)|(?:(?:doi.org/)?(?:(?:urn:)|(?:doi:)|(?:urn:doi:))))(10[/%:][a-zA-Z0-9]{3,})";
    private static final String HTTP_EXP = "https?://[^\\s]+?(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:%](?:.+))";
    private static final String SHORT_DOI_HTTP_EXP = "https?://[^\\s]+?(?:(?:[\\s/]?(?:(?:urn:)|(?:doi:)|(?:urn:doi:)))|(?:\\s?/?))(10[/%:][a-zA-Z0-9]{3,})\\s*$";
    private static final Pattern EXACT_DOI_PATT = Pattern.compile("^(?:https?://[^\\s]+?)?(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:%](?:.+))$", 2);
    private static final Pattern FIND_DOI_PATT = Pattern.compile("(?:https?://[^\\s]+?)?(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:](?:[^\\s,]+[^,;(\\.\\s)]))", 2);
    private static final Pattern EXACT_SHORT_DOI_SHORTCUT = Pattern.compile("^\\s*(?:https?://)?(?:www\\.)?(?:doi\\.org/)([a-z0-9]{4,10})\\s*$", 2);
    private static final Pattern FIND_SHORT_DOI_SHORTCUT = Pattern.compile("(?:https?://)?(?:www\\.)?(?:doi\\.org/)([a-z0-9]{4,10})", 2);
    private static final Pattern EXACT_SHORT_DOI_PATT = Pattern.compile("^(?:\\s*(?:https?://)?(?:www\\.)?[a-zA-Z\\.]*doi[a-zA-Z\\.]*\\.[a-zA-Z]{2,10}/)?(?:(?:[\\s/]?(?:(?:urn:)|(?:doi:)|(?:urn:doi:)))|(?:\\s?/?))(10[/%:][a-zA-Z0-9]{3,})\\s*$", 2);
    private static final Pattern FIND_SHORT_DOI_PATT = Pattern.compile("(?:https?://[^\\s]+?)?(?:(?:(?:www\\.)?doi\\.org/)|(?:(?:doi.org/)?(?:(?:urn:)|(?:doi:)|(?:urn:doi:))))(10[/%:][a-zA-Z0-9]{3,})", 2);
    private static final String CHARS_TO_REMOVE = "[\\s+\\\\{}\\[\\]`|[^\\x00-\\x7F]]";
    private final String doi;
    private boolean isShortDoi = false;

    public DOI(String doi) {
        Matcher matcher;
        Objects.requireNonNull(doi);
        String trimmedDoi = doi.trim();
        if (doi.matches(HTTP_EXP) || doi.matches(SHORT_DOI_HTTP_EXP)) {
            trimmedDoi = URLDecoder.decode(trimmedDoi, StandardCharsets.UTF_8);
        }
        if ((matcher = EXACT_DOI_PATT.matcher(trimmedDoi)).find()) {
            this.doi = matcher.group(1);
        } else {
            Matcher shortDoiMatcher = EXACT_SHORT_DOI_PATT.matcher(trimmedDoi);
            if (shortDoiMatcher.find()) {
                this.doi = shortDoiMatcher.group(1);
                this.isShortDoi = true;
            } else {
                Matcher shortcutDoiMatcher = EXACT_SHORT_DOI_SHORTCUT.matcher(trimmedDoi);
                if (shortcutDoiMatcher.find()) {
                    this.doi = "10/" + shortcutDoiMatcher.group(1);
                    this.isShortDoi = true;
                } else {
                    throw new IllegalArgumentException(trimmedDoi + " is not a valid DOI/Short DOI.");
                }
            }
        }
    }

    public static Optional<DOI> parse(String doi) {
        try {
            LatexToUnicodeFormatter formatter = new LatexToUnicodeFormatter();
            String cleanedDOI = doi;
            cleanedDOI = URLDecoder.decode(cleanedDOI, StandardCharsets.UTF_8);
            cleanedDOI = cleanedDOI.replaceAll("\\^", "");
            cleanedDOI = formatter.format(cleanedDOI);
            cleanedDOI = cleanedDOI.replaceAll(CHARS_TO_REMOVE, "");
            if (cleanedDOI.startsWith("_") && cleanedDOI.endsWith("_")) {
                if (cleanedDOI.length() == 1) {
                    return Optional.empty();
                }
                cleanedDOI = cleanedDOI.substring(1, cleanedDOI.length() - 1);
            }
            return Optional.of(new DOI(cleanedDOI));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Optional.empty();
        }
    }

    public static boolean isValid(String doi) {
        return DOI.parse(doi).isPresent();
    }

    public static Optional<DOI> findInText(String text) {
        Optional<DOI> result = Optional.empty();
        Matcher matcher = FIND_DOI_PATT.matcher(text);
        if (matcher.find()) {
            result = Optional.of(new DOI(matcher.group(1)));
        }
        if ((matcher = FIND_SHORT_DOI_PATT.matcher(text)).find()) {
            result = Optional.of(new DOI(matcher.group(1)));
        }
        if ((matcher = FIND_SHORT_DOI_SHORTCUT.matcher(text)).find()) {
            result = Optional.of(new DOI(matcher.group(0)));
        }
        return result;
    }

    public String toString() {
        return "DOI{doi='" + this.doi + "'}";
    }

    public String getDOI() {
        return this.doi;
    }

    public boolean isShortDoi() {
        return this.isShortDoi;
    }

    @Override
    public Optional<URI> getExternalURI() {
        return this.getExternalURIFromBase(RESOLVER);
    }

    public Optional<URI> getExternalURIWithCustomBase(String customBase) {
        return this.getExternalURIFromBase(URI.create(customBase));
    }

    public Optional<URI> getExternalURIFromBase(URI base) {
        try {
            URI uri = new URI(base.getScheme(), base.getHost(), "/" + this.doi, null);
            return Optional.of(uri);
        }
        catch (URISyntaxException e) {
            LOGGER.error(this.doi + " could not be encoded as URI.", (Throwable)e);
            return Optional.empty();
        }
    }

    public String getURIAsASCIIString() {
        return this.getExternalURI().map(URI::toASCIIString).orElse("");
    }

    @Override
    public Field getDefaultField() {
        return StandardField.DOI;
    }

    @Override
    public String getNormalized() {
        return this.doi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DOI other = (DOI)o;
        return this.doi.equalsIgnoreCase(other.doi);
    }

    public int hashCode() {
        return Objects.hash(this.doi.toLowerCase(Locale.ENGLISH));
    }
}

