/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.migrations;

import com.github.javakeyring.Keyring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.logic.citationkeypattern.GlobalCitationKeyPatterns;
import org.jabref.logic.shared.security.Password;
import org.jabref.logic.util.OS;
import org.jabref.migrations.CustomEntryTypePreferenceMigration;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.CleanupPreferences;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesMigrations {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesMigrations.class);

    private PreferencesMigrations() {
    }

    public static void runMigrations(JabRefPreferences preferences, BibEntryTypesManager entryTypesManager) {
        Preferences mainPrefsNode = Preferences.userRoot().node("/org/jabref");
        PreferencesMigrations.upgradePrefsToOrgJabRef(mainPrefsNode);
        PreferencesMigrations.upgradeSortOrder(preferences);
        PreferencesMigrations.upgradeFaultyEncodingStrings(preferences);
        PreferencesMigrations.upgradeLabelPatternToCitationKeyPattern(preferences, mainPrefsNode);
        PreferencesMigrations.upgradeImportFileAndDirePatterns(preferences, mainPrefsNode);
        PreferencesMigrations.upgradeStoredBibEntryTypes(preferences, mainPrefsNode, entryTypesManager);
        PreferencesMigrations.upgradeKeyBindingsToJavaFX(preferences);
        PreferencesMigrations.addCrossRefRelatedFieldsForAutoComplete(preferences);
        PreferencesMigrations.upgradePreviewStyle(preferences);
        PreferencesMigrations.changeColumnVariableNamesFor51(preferences);
        PreferencesMigrations.upgradeColumnPreferences(preferences);
        PreferencesMigrations.restoreVariablesForBackwardCompatibility(preferences);
        PreferencesMigrations.upgradeCleanups(preferences);
        PreferencesMigrations.moveApiKeysToKeyring(preferences);
        PreferencesMigrations.removeCommentsFromCustomEditorTabs(preferences);
    }

    private static void upgradePrefsToOrgJabRef(Preferences mainPrefsNode) {
        try {
            if (mainPrefsNode.childrenNames().length != 0) {
                LOGGER.debug("New prefs node already exists with content - skipping migration");
            } else if (mainPrefsNode.parent().parent().nodeExists("net/sf/jabref")) {
                LOGGER.info("Migrating old preferences.");
                Preferences oldNode = mainPrefsNode.parent().parent().node("net/sf/jabref");
                PreferencesMigrations.copyPrefsRecursively(oldNode, mainPrefsNode);
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.error("Migrating old preferences failed.", (Throwable)ex);
        }
    }

    private static void copyPrefsRecursively(Preferences from, Preferences to) throws BackingStoreException {
        for (String key : from.keys()) {
            String newValue = from.get(key, "");
            if (newValue.contains("net.sf")) {
                newValue = newValue.replace("net.sf", "org");
            }
            to.put(key, newValue);
        }
        for (String child : from.childrenNames()) {
            Preferences childNode = from.node(child);
            Preferences newChildNode = to.node(child);
            PreferencesMigrations.copyPrefsRecursively(childNode, newChildNode);
        }
    }

    private static void upgradeFaultyEncodingStrings(JabRefPreferences prefs) {
        String defaultEncoding = prefs.get("defaultEncoding");
        if (defaultEncoding == null) {
            return;
        }
        HashMap<String, String> encodingMap = new HashMap<String, String>();
        encodingMap.put("UTF8", "UTF-8");
        encodingMap.put("Cp1250", "CP1250");
        encodingMap.put("Cp1251", "CP1251");
        encodingMap.put("Cp1252", "CP1252");
        encodingMap.put("Cp1253", "CP1253");
        encodingMap.put("Cp1254", "CP1254");
        encodingMap.put("Cp1257", "CP1257");
        encodingMap.put("ISO8859_1", "ISO8859-1");
        encodingMap.put("ISO8859_2", "ISO8859-2");
        encodingMap.put("ISO8859_3", "ISO8859-3");
        encodingMap.put("ISO8859_4", "ISO8859-4");
        encodingMap.put("ISO8859_5", "ISO8859-5");
        encodingMap.put("ISO8859_6", "ISO8859-6");
        encodingMap.put("ISO8859_7", "ISO8859-7");
        encodingMap.put("ISO8859_8", "ISO8859-8");
        encodingMap.put("ISO8859_9", "ISO8859-9");
        encodingMap.put("ISO8859_13", "ISO8859-13");
        encodingMap.put("ISO8859_15", "ISO8859-15");
        encodingMap.put("KOI8_R", "KOI8-R");
        encodingMap.put("Big5_HKSCS", "Big5-HKSCS");
        encodingMap.put("EUC_JP", "EUC-JP");
        if (encodingMap.containsKey(defaultEncoding)) {
            prefs.put("defaultEncoding", (String)encodingMap.get(defaultEncoding));
        }
    }

    private static void upgradeSortOrder(JabRefPreferences prefs) {
        if (prefs.get("exportInSpecifiedOrder", null) == null) {
            if (prefs.getBoolean("exportInStandardOrder", false)) {
                prefs.putBoolean("exportInSpecifiedOrder", true);
                prefs.put("exportPriSort", StandardField.AUTHOR.getName());
                prefs.put("exportSecSort", StandardField.EDITOR.getName());
                prefs.put("exportTerSort", StandardField.YEAR.getName());
                prefs.putBoolean("exportPriDescending", false);
                prefs.putBoolean("exportSecDescending", false);
                prefs.putBoolean("exportTerDescending", false);
            } else if (prefs.getBoolean("exportInTitleOrder", false)) {
                prefs.putBoolean("exportInSpecifiedOrder", true);
                prefs.put("exportPriSort", StandardField.TITLE.getName());
                prefs.put("exportSecSort", StandardField.AUTHOR.getName());
                prefs.put("exportTerSort", StandardField.EDITOR.getName());
                prefs.putBoolean("exportPriDescending", false);
                prefs.putBoolean("exportSecDescending", false);
                prefs.putBoolean("exportTerDescending", false);
            }
        }
    }

    private static void upgradeStoredBibEntryTypes(JabRefPreferences prefs, Preferences mainPrefsNode, BibEntryTypesManager entryTypesManager) {
        try {
            if (!mainPrefsNode.nodeExists("customizedBibtexTypes") && !mainPrefsNode.nodeExists("customizedBiblatexTypes")) {
                LOGGER.info("Migrating old custom entry types.");
                CustomEntryTypePreferenceMigration.upgradeStoredBibEntryTypes(prefs.getLibraryPreferences().getDefaultBibDatabaseMode(), prefs, entryTypesManager);
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.error("Migrating old custom entry types failed.", (Throwable)ex);
        }
    }

    private static void upgradeLabelPatternToCitationKeyPattern(JabRefPreferences prefs, Preferences mainPrefsNode) {
        String V3_6_DEFAULT_BIBTEX_KEYPATTERN = "defaultBibtexKeyPattern";
        String V3_6_BIBTEX_KEYPATTERN_NODE = "bibtexkeypatterns";
        String V3_3_DEFAULT_LABELPATTERN = "defaultLabelPattern";
        String V3_3_LOGIC_LABELPATTERN = "logic/labelpattern";
        String V3_0_LOGIC_LABELPATTERN = "logic/labelPattern";
        String LEGACY_LABELPATTERN = "labelPattern";
        try {
            String oldDefault;
            if (mainPrefsNode.get("defaultBibtexKeyPattern", null) == null && (oldDefault = mainPrefsNode.get("defaultLabelPattern", null)) != null) {
                prefs.put("defaultBibtexKeyPattern", oldDefault);
                LOGGER.info("Upgraded old default key generator pattern '{}' to new version.", (Object)oldDefault);
            }
            if (mainPrefsNode.nodeExists("bibtexkeypatterns")) {
                return;
            }
            if (mainPrefsNode.nodeExists("logic/labelpattern")) {
                PreferencesMigrations.migrateTypedKeyPrefs(prefs, mainPrefsNode.node("logic/labelpattern"));
            } else if (mainPrefsNode.nodeExists("logic/labelPattern")) {
                PreferencesMigrations.migrateTypedKeyPrefs(prefs, mainPrefsNode.node("logic/labelPattern"));
            } else if (mainPrefsNode.nodeExists("labelPattern")) {
                PreferencesMigrations.migrateTypedKeyPrefs(prefs, mainPrefsNode.node("labelPattern"));
            }
        }
        catch (BackingStoreException e) {
            LOGGER.error("Migrating old bibtexKeyPatterns failed.", (Throwable)e);
        }
    }

    private static void migrateFileImportPattern(String oldStylePattern, String newStylePattern, JabRefPreferences prefs, Preferences mainPrefsNode) {
        String preferenceFileNamePattern = mainPrefsNode.get("importFileNamePattern", null);
        if (preferenceFileNamePattern != null && oldStylePattern.equals(preferenceFileNamePattern)) {
            String fileNamePattern;
            mainPrefsNode.put("importFileNamePattern", newStylePattern);
            LOGGER.info("migrated old style importFileNamePattern value \"" + oldStylePattern + "\" to new value \"" + newStylePattern + "\" in the preference file");
            if (prefs.hasKey("importFileNamePattern") && oldStylePattern.equals(fileNamePattern = prefs.get("importFileNamePattern"))) {
                prefs.put("importFileNamePattern", newStylePattern);
                LOGGER.info("migrated old style importFileNamePattern value \"" + oldStylePattern + "\" to new value \"" + newStylePattern + "\" in the running application");
            }
        }
    }

    static void upgradeImportFileAndDirePatterns(JabRefPreferences prefs, Preferences mainPrefsNode) {
        if (mainPrefsNode.get("importFileNamePattern", null) != null) {
            int i;
            String[] oldStylePatterns = new String[]{"\\bibtexkey", "\\bibtexkey\\begin{title} - \\format[RemoveBrackets]{\\title}\\end{title}"};
            String[] newStylePatterns = new String[]{"[citationkey]", "[citationkey] - [title]"};
            String[] oldDisplayStylePattern = new String[]{"bibtexkey", "bibtexkey - title"};
            for (i = 0; i < oldStylePatterns.length; ++i) {
                PreferencesMigrations.migrateFileImportPattern(oldStylePatterns[i], newStylePatterns[i], prefs, mainPrefsNode);
            }
            for (i = 0; i < oldDisplayStylePattern.length; ++i) {
                PreferencesMigrations.migrateFileImportPattern(oldDisplayStylePattern[i], newStylePatterns[i], prefs, mainPrefsNode);
            }
        }
    }

    private static void upgradeKeyBindingsToJavaFX(JabRefPreferences prefs) {
        UnaryOperator replaceKeys = str -> {
            String result = str.replace("ctrl ", "ctrl+");
            result = result.replace("shift ", "shift+");
            result = result.replace("alt ", "alt+");
            result = result.replace("meta ", "meta+");
            return result;
        };
        ArrayList<String> keys = new ArrayList<String>(prefs.getStringList("bindings"));
        keys.replaceAll(replaceKeys);
        prefs.putStringList("bindings", keys);
    }

    private static void addCrossRefRelatedFieldsForAutoComplete(JabRefPreferences prefs) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(prefs.getStringList("autoCompleteFields"));
        keys.add("crossref");
        keys.add("related");
        keys.add("entryset");
        prefs.putStringList("autoCompleteFields", new ArrayList<String>(keys));
    }

    private static void migrateTypedKeyPrefs(JabRefPreferences prefs, Preferences oldPatternPrefs) throws BackingStoreException {
        LOGGER.info("Found old Bibtex Key patterns which will be migrated to new version.");
        GlobalCitationKeyPatterns keyPattern = GlobalCitationKeyPatterns.fromPattern(prefs.get("defaultBibtexKeyPattern"));
        for (String key : oldPatternPrefs.keys()) {
            keyPattern.addCitationKeyPattern(EntryTypeFactory.parse(key), oldPatternPrefs.get(key, null));
        }
        prefs.storeGlobalCitationKeyPattern(keyPattern);
    }

    protected static void upgradePreviewStyle(JabRefPreferences prefs) {
        String currentPreviewStyle = prefs.get("previewStyle");
        String migratedStyle = currentPreviewStyle.replace("\\begin{review}<BR><BR><b>Review: </b> \\format[HTMLChars]{\\review} \\end{review}", "\\begin{comment}<BR><BR><b>Comment: </b> \\format[Markdown,HTMLChars]{\\comment} \\end{comment}").replace("\\format[HTMLChars]{\\comment}", "\\format[Markdown,HTMLChars]{\\comment}").replace("\\format[Markdown,HTMLChars]{\\comment}", "\\format[Markdown,HTMLChars(keepCurlyBraces)]{\\comment}").replace("<b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>", "<b><i>\\bibtextype</i><a name=\"\\citationkey\">\\begin{citationkey} (\\citationkey)</a>").replace("\\end{bibtexkey}</b><br>__NEWLINE__", "\\end{citationkey}</b><br>__NEWLINE__");
        prefs.put("previewStyle", migratedStyle);
    }

    static void upgradeColumnPreferences(JabRefPreferences preferences) {
        List<String> columnNames = preferences.getStringList("mainTableColumnNames");
        List<Double> columnWidths = preferences.getStringList("mainTableColumnWidths").stream().map(string -> {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException e) {
                return 100.0;
            }
        }).toList();
        String normalFieldTypeString = MainTableColumnModel.Type.NORMALFIELD.getName() + MainTableColumnModel.COLUMNS_QUALIFIER_DELIMITER;
        if (!columnNames.isEmpty() && columnNames.stream().noneMatch(name -> name.contains(normalFieldTypeString))) {
            ArrayList<MainTableColumnModel> columns = new ArrayList<MainTableColumnModel>();
            columns.add(new MainTableColumnModel(MainTableColumnModel.Type.GROUPS));
            columns.add(new MainTableColumnModel(MainTableColumnModel.Type.FILES));
            columns.add(new MainTableColumnModel(MainTableColumnModel.Type.LINKED_IDENTIFIER));
            for (int i = 0; i < columnNames.size(); ++i) {
                String name2 = columnNames.get(i);
                double columnWidth = 100.0;
                MainTableColumnModel.Type type = SpecialField.fromName(name2).map(field -> MainTableColumnModel.Type.SPECIALFIELD).orElse(MainTableColumnModel.Type.NORMALFIELD);
                if (i < columnWidths.size()) {
                    columnWidth = columnWidths.get(i);
                }
                columns.add(new MainTableColumnModel(type, name2, columnWidth));
            }
            preferences.putStringList("mainTableColumnNames", columns.stream().map(MainTableColumnModel::getName).collect(Collectors.toList()));
            preferences.putStringList("mainTableColumnWidths", columns.stream().map(MainTableColumnModel::getWidth).map(Double::intValue).map(Object::toString).collect(Collectors.toList()));
            preferences.putStringList("mainTableColumnSortTypes", columns.stream().map(MainTableColumnModel::getSortType).map(Enum::toString).collect(Collectors.toList()));
        }
    }

    static void changeColumnVariableNamesFor51(JabRefPreferences preferences) {
        String V5_0_COLUMN_NAMES = "columnNames";
        String V5_0_COLUMN_WIDTHS = "columnWidths";
        String V5_0_COLUMN_SORT_TYPES = "columnSortTypes";
        String V5_0_COLUMN_SORT_ORDER = "columnSortOrder";
        String V5_1_COLUMN_NAMES = "mainTableColumnNames";
        String V5_1_COLUMN_WIDTHS = "mainTableColumnWidths";
        String V5_1_COLUMN_SORT_TYPES = "mainTableColumnSortTypes";
        String V5_1_COLUMN_SORT_ORDER = "mainTableColumnSortOrder";
        List<String> oldColumnNames = preferences.getStringList("columnNames");
        List<String> columnNames = preferences.getStringList("mainTableColumnNames");
        if (!oldColumnNames.isEmpty() && columnNames.isEmpty()) {
            preferences.putStringList("mainTableColumnNames", preferences.getStringList("columnNames"));
            preferences.putStringList("mainTableColumnWidths", preferences.getStringList("columnWidths"));
            preferences.putStringList("mainTableColumnSortTypes", preferences.getStringList("columnSortTypes"));
            preferences.putStringList("mainTableColumnSortOrder", preferences.getStringList("columnSortOrder"));
        }
    }

    static void restoreVariablesForBackwardCompatibility(JabRefPreferences preferences) {
        List<String> oldColumnNames = preferences.getStringList("mainTableColumnNames");
        List<String> fieldColumnNames = oldColumnNames.stream().filter(columnName -> columnName.startsWith("field:") || columnName.startsWith("special:")).map(columnName -> {
            if (columnName.startsWith("field:")) {
                return columnName.substring(6);
            }
            return columnName.substring(8);
        }).collect(Collectors.toList());
        if (!fieldColumnNames.isEmpty()) {
            preferences.putStringList("columnNames", fieldColumnNames);
            ArrayList<String> fieldColumnWidths = new ArrayList<String>(Collections.emptyList());
            for (int i = 0; i < fieldColumnNames.size(); ++i) {
                fieldColumnWidths.add("100");
            }
            preferences.putStringList("columnWidths", fieldColumnWidths);
            preferences.put("columnSortTypes", "");
            preferences.put("columnSortOrder", "");
        }
        try {
            String fontSizeAsString = preferences.get("mainFontSize");
            int fontSizeAsInt = (int)Math.round(Double.parseDouble(fontSizeAsString));
            preferences.putInt("mainFontSize", fontSizeAsInt);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static void upgradeCleanups(JabRefPreferences prefs) {
        List<String> formatterCleanups;
        String V5_8_CLEANUP = "CleanUp";
        String V6_0_CLEANUP_JOBS = "CleanUpJobs";
        String V5_8_CLEANUP_FIELD_FORMATTERS = "CleanUpFormatters";
        String V6_0_CLEANUP_FIELD_FORMATTERS = "CleanUpFormatters";
        String V6_0_CLEANUP_FIELD_FORMATTERS_ENABLED = "CleanUpFormattersEnabled";
        ArrayList<String> activeJobs = new ArrayList<String>();
        for (CleanupPreferences.CleanupStep action : EnumSet.allOf(CleanupPreferences.CleanupStep.class)) {
            Optional<String> job = prefs.getAsOptional("CleanUp" + action.name());
            if (!job.isPresent() || !Boolean.parseBoolean(job.get())) continue;
            activeJobs.add(action.name());
        }
        if (!activeJobs.isEmpty()) {
            prefs.put("CleanUpJobs", String.join((CharSequence)";", activeJobs));
        }
        if ((formatterCleanups = List.of(StringUtil.unifyLineBreaks(prefs.get("CleanUpFormatters"), "\n").split("\n"))).size() >= 2 && (formatterCleanups.getFirst().equals("enabled") || formatterCleanups.getFirst().equals("disabled"))) {
            prefs.putBoolean("CleanUpFormattersEnabled", formatterCleanups.getFirst().equals("enabled") ? Boolean.TRUE : Boolean.FALSE);
            prefs.put("CleanUpFormatters", String.join((CharSequence)OS.NEWLINE, formatterCleanups.subList(1, formatterCleanups.size() - 1)));
        }
    }

    static void moveApiKeysToKeyring(JabRefPreferences preferences) {
        String V5_9_FETCHER_CUSTOM_KEY_NAMES = "fetcherCustomKeyNames";
        String V5_9_FETCHER_CUSTOM_KEYS = "fetcherCustomKeys";
        List<String> names = preferences.getStringList("fetcherCustomKeyNames");
        List<String> keys = preferences.getStringList("fetcherCustomKeys");
        if (!keys.isEmpty() && names.size() == keys.size()) {
            try (Keyring keyring = Keyring.create();){
                for (int i = 0; i < names.size(); ++i) {
                    keyring.setPassword("org.jabref.customapikeys", names.get(i), new Password(keys.get(i), preferences.getInternalPreferences().getUserAndHost()).encrypt());
                }
                preferences.deleteKey("fetcherCustomKeys");
            }
            catch (Exception ex) {
                LOGGER.error("Unable to open key store", (Throwable)ex);
            }
        }
    }

    static void removeCommentsFromCustomEditorTabs(JabRefPreferences preferences) {
        preferences.getEntryEditorPreferences().getEntryEditorTabs().remove((Object)"Comments");
    }
}

