/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.xmp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.xml.DomXmpParser;
import org.jabref.logic.xmp.EncryptedPdfsNotSupportedException;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.logic.xmp.XmpUtilReader;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmpUtilShared {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmpUtilShared.class);

    private XmpUtilShared() {
    }

    protected static XMPMetadata parseXmpMetadata(InputStream is) throws IOException {
        try {
            DomXmpParser parser = new DomXmpParser();
            XMPMetadata meta = parser.parse(is);
            return meta;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static boolean hasMetadata(Path path, XmpPreferences xmpPreferences) {
        try {
            List<BibEntry> bibEntries = new XmpUtilReader().readXmp(path, xmpPreferences);
            return !bibEntries.isEmpty();
        }
        catch (EncryptedPdfsNotSupportedException ex) {
            LOGGER.info("Encryption not supported by XMPUtil");
            return false;
        }
        catch (IOException e) {
            LOGGER.debug("No metadata was found. Path: {}", (Object)path.toString());
            return false;
        }
    }
}

