/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.strings;

public class QuotedStringTokenizer {
    private final String content;
    private final int contentLength;
    private final String delimiters;
    private final char quoteChar;
    private int index;

    public QuotedStringTokenizer(String content, String delimiters, char quoteCharacter) {
        this.content = content;
        this.delimiters = delimiters;
        this.quoteChar = quoteCharacter;
        this.contentLength = this.content.length();
        while (this.isDelimiter(this.content.charAt(this.index)) && this.index < this.contentLength) {
            ++this.index;
        }
    }

    public String nextToken() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.index < this.contentLength) {
            char c = this.content.charAt(this.index);
            if (c == this.quoteChar) {
                ++this.index;
                stringBuilder.append(c);
                if (this.index < this.contentLength) {
                    stringBuilder.append(this.content.charAt(this.index));
                }
            } else {
                if (this.isDelimiter(c)) {
                    ++this.index;
                    return stringBuilder.toString();
                }
                stringBuilder.append(c);
            }
            ++this.index;
        }
        return stringBuilder.toString();
    }

    private boolean isDelimiter(char c) {
        return this.delimiters.indexOf(c) >= 0;
    }

    public boolean hasMoreTokens() {
        return this.index < this.contentLength;
    }
}

