/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.FilePreferences;

public class DatabaseFileLookup {
    private final Set<Path> fileCache = new HashSet<Path>();
    private final List<Path> possibleFilePaths;
    private final Path pathOfDatabase;

    public DatabaseFileLookup(BibDatabaseContext databaseContext, FilePreferences filePreferences) {
        Objects.requireNonNull(databaseContext);
        this.possibleFilePaths = Optional.ofNullable(databaseContext.getFileDirectories(filePreferences)).orElse(new ArrayList());
        for (BibEntry entry : databaseContext.getDatabase().getEntries()) {
            this.fileCache.addAll(this.parseFileField(entry));
        }
        this.pathOfDatabase = databaseContext.getDatabasePath().orElse(Path.of("", new String[0]));
    }

    public boolean lookupDatabase(Path pathname) {
        return this.fileCache.contains(pathname);
    }

    private List<Path> parseFileField(BibEntry entry) {
        Objects.requireNonNull(entry);
        return entry.getFiles().stream().filter(file -> !file.isOnlineLink()).map(file -> file.findIn(this.possibleFilePaths)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Path getPathOfDatabase() {
        return this.pathOfDatabase;
    }
}

