/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jabref.logic.util.FileType;

public class UnknownFileType
implements FileType {
    private final List<String> extensions;

    public UnknownFileType(String ... extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i].contains(".")) {
                extensions[i] = extensions[i].substring(extensions[i].indexOf(46) + 1);
            }
            extensions[i] = extensions[i].toLowerCase(Locale.ROOT);
        }
        this.extensions = Arrays.asList(extensions);
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileType)) {
            return false;
        }
        FileType other = (FileType)o;
        Collections.sort(this.extensions);
        Collections.sort(other.getExtensions());
        return this.extensions.equals(other.getExtensions());
    }

    public int hashCode() {
        return Objects.hash(this.extensions);
    }

    @Override
    public String getName() {
        return "Unknown File Type" + this.extensions.toString();
    }
}

