/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jabref.logic.util.HeadlessExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayTaskThrottler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayTaskThrottler.class);
    private final ScheduledThreadPoolExecutor executor;
    private int delay;
    private ScheduledFuture<?> scheduledTask;

    public DelayTaskThrottler(int delay) {
        this.delay = delay;
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.setRemoveOnCancelPolicy(true);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    public ScheduledFuture<?> schedule(Runnable command) {
        if (this.scheduledTask != null) {
            this.cancel();
        }
        try {
            this.scheduledTask = this.executor.schedule(command, (long)this.delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            LOGGER.debug("Rejecting while another process is already running.");
        }
        return this.scheduledTask;
    }

    public <T> ScheduledFuture<?> scheduleTask(Callable<?> command) {
        if (this.scheduledTask != null) {
            this.cancel();
        }
        try {
            this.scheduledTask = this.executor.schedule(command, (long)this.delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            LOGGER.debug("Rejecting while another process is already running.");
        }
        return this.scheduledTask;
    }

    public void execute(Runnable command) {
        this.delay = 0;
        this.schedule(command);
    }

    public void cancel() {
        this.scheduledTask.cancel(false);
    }

    public void shutdown() {
        HeadlessExecutorService.gracefullyShutdown(this.executor);
    }
}

