/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.BibDatabaseContextChangedEvent;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.FieldChangedEvent;
import org.jabref.model.entry.field.Field;

public class CoarseChangeFilter {
    private final BibDatabaseContext context;
    private final EventBus eventBus = new EventBus();
    private Optional<Field> lastFieldChanged;
    private Optional<BibEntry> lastEntryChanged;
    private int totalDelta;

    public CoarseChangeFilter(BibDatabaseContext bibDatabaseContext) {
        this.context = bibDatabaseContext;
        this.context.getDatabase().registerListener(this);
        this.context.getMetaData().registerListener(this);
        this.lastFieldChanged = Optional.empty();
        this.lastEntryChanged = Optional.empty();
    }

    @Subscribe
    public synchronized void listen(BibDatabaseContextChangedEvent event) {
        if (event instanceof FieldChangedEvent) {
            FieldChangedEvent fieldChange = (FieldChangedEvent)event;
            boolean isNewEdit = this.lastFieldChanged.isEmpty() || this.lastEntryChanged.isEmpty();
            boolean isChangedField = this.lastFieldChanged.filter(f -> !f.equals(fieldChange.getField())).isPresent();
            boolean isChangedEntry = this.lastEntryChanged.filter(e -> !e.equals(fieldChange.getBibEntry())).isPresent();
            boolean isEditChanged = !isNewEdit && (isChangedField || isChangedEntry);
            boolean isMajorChange = fieldChange.getMajorCharacterChange() > 1;
            fieldChange.setFilteredOut(!isEditChanged && !isMajorChange);
            this.eventBus.post((Object)fieldChange);
            this.lastFieldChanged = Optional.of(fieldChange.getField());
            this.lastEntryChanged = Optional.of(fieldChange.getBibEntry());
        } else {
            this.eventBus.post((Object)event);
        }
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    public void unregisterListener(Object listener) {
        this.eventBus.unregister(listener);
    }

    public void shutdown() {
        this.context.getDatabase().unregisterListener(this);
        this.context.getMetaData().unregisterListener(this);
    }
}

