/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.shared;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jabref.logic.shared.DBMSProcessor;
import org.jabref.logic.shared.DBMSSynchronizer;
import org.jabref.logic.shared.DatabaseConnection;
import org.jabref.logic.shared.listener.PostgresSQLNotificationListener;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.model.entry.BibEntry;
import org.postgresql.PGConnection;

public class PostgreSQLProcessor
extends DBMSProcessor {
    private PostgresSQLNotificationListener listener;
    private int VERSION_DB_STRUCT_DEFAULT = -1;
    private final int CURRENT_VERSION_DB_STRUCT = 1;

    public PostgreSQLProcessor(DatabaseConnection connection) {
        super(connection);
    }

    @Override
    public void setUp() throws SQLException {
        if (this.checkTableAvailability("ENTRY", "FIELD", "METADATA")) {
            this.VERSION_DB_STRUCT_DEFAULT = 0;
        }
        this.connection.createStatement().executeUpdate("CREATE SCHEMA IF NOT EXISTS jabref");
        this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS " + this.escape_Table("ENTRY") + " (\"SHARED_ID\" SERIAL PRIMARY KEY, \"TYPE\" VARCHAR, \"VERSION\" INTEGER DEFAULT 1)");
        this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS " + this.escape_Table("FIELD") + " (\"ENTRY_SHARED_ID\" INTEGER REFERENCES " + this.escape_Table("ENTRY") + "(\"SHARED_ID\") ON DELETE CASCADE, \"NAME\" VARCHAR, \"VALUE\" TEXT)");
        this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS " + this.escape_Table("METADATA") + " (\"KEY\" VARCHAR,\"VALUE\" TEXT)");
        Map<String, String> metadata = this.getSharedMetaData();
        if (metadata.get("VersionDBStructure") != null) {
            try {
                this.VERSION_DB_STRUCT_DEFAULT = Integer.parseInt(metadata.get("VersionDBStructure").replace(";", ""));
            }
            catch (Exception e) {
                LOGGER.warn("[VERSION_DB_STRUCT_DEFAULT] not Integer!");
            }
        } else {
            LOGGER.warn("[VERSION_DB_STRUCT_DEFAULT] not Exist!");
        }
        if (this.VERSION_DB_STRUCT_DEFAULT < 1) {
            if (this.VERSION_DB_STRUCT_DEFAULT == 0) {
                LOGGER.info("Migrating from VersionDBStructure == 0");
                this.connection.createStatement().executeUpdate("INSERT INTO " + this.escape_Table("ENTRY") + " SELECT * FROM \"ENTRY\"");
                this.connection.createStatement().executeUpdate("INSERT INTO " + this.escape_Table("FIELD") + " SELECT * FROM \"FIELD\"");
                this.connection.createStatement().executeUpdate("INSERT INTO " + this.escape_Table("METADATA") + " SELECT * FROM \"METADATA\"");
                this.connection.createStatement().execute("SELECT setval('jabref.\"ENTRY_SHARED_ID_seq\"', (select max(\"SHARED_ID\") from jabref.\"ENTRY\"))");
                metadata = this.getSharedMetaData();
            }
            metadata.put("VersionDBStructure", String.valueOf(1));
            this.setSharedMetaData(metadata);
        }
    }

    @Override
    protected void insertIntoEntryTable(List<BibEntry> bibEntries) {
        StringBuilder insertIntoEntryQuery = new StringBuilder().append("INSERT INTO ").append(this.escape_Table("ENTRY")).append("(").append(this.escape("TYPE")).append(") VALUES(?)");
        insertIntoEntryQuery.append(", (?)".repeat(Math.max(0, bibEntries.size() - 1)));
        try (PreparedStatement preparedEntryStatement = this.connection.prepareStatement(insertIntoEntryQuery.toString(), 1);){
            for (int i = 0; i < bibEntries.size(); ++i) {
                preparedEntryStatement.setString(i + 1, bibEntries.get(i).getType().getName());
            }
            preparedEntryStatement.executeUpdate();
            try (ResultSet generatedKeys = preparedEntryStatement.getGeneratedKeys();){
                for (BibEntry bibEntry : bibEntries) {
                    generatedKeys.next();
                    bibEntry.getSharedBibEntryData().setSharedID(generatedKeys.getInt(1));
                }
                if (generatedKeys.next()) {
                    LOGGER.error("Some shared IDs left unassigned");
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error during entry insertion", (Throwable)e);
        }
    }

    @Override
    String escape(String expression) {
        return "\"" + expression + "\"";
    }

    @Override
    String escape_Table(String expression) {
        return "jabref." + this.escape(expression);
    }

    @Override
    Integer getCURRENT_VERSION_DB_STRUCT() {
        return 1;
    }

    @Override
    public void startNotificationListener(DBMSSynchronizer dbmsSynchronizer) {
        try {
            this.connection.createStatement().execute("LISTEN jabrefLiveUpdate");
            PGConnection pgConnection = this.connection.unwrap(PGConnection.class);
            this.listener = new PostgresSQLNotificationListener(dbmsSynchronizer, pgConnection);
            HeadlessExecutorService.INSTANCE.execute(this.listener);
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error during starting the notification listener", (Throwable)e);
        }
    }

    @Override
    public void stopNotificationListener() {
        try {
            this.listener.stop();
            this.connection.close();
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error during stopping the notification listener", (Throwable)e);
        }
    }

    @Override
    public void notifyClients() {
        try {
            this.connection.createStatement().execute("NOTIFY jabrefLiveUpdate, '" + PROCESSOR_ID + "';");
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error during client notification", (Throwable)e);
        }
    }
}

