/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.remote.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javafx.util.Pair;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.remote.Protocol;
import org.jabref.logic.remote.RemoteMessage;
import org.jabref.logic.remote.RemotePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteClient.class);
    private static final int TIMEOUT = 120000;
    private final int port;

    public RemoteClient(int port) {
        this.port = port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ping() {
        try (Protocol protocol = this.openNewConnection();){
            protocol.sendMessage(RemoteMessage.PING);
            Pair<RemoteMessage, Object> response = protocol.receiveMessage();
            if (response.getKey() == RemoteMessage.PONG && "jabref".equals(response.getValue())) {
                boolean bl = true;
                return bl;
            }
            String port = String.valueOf(this.port);
            String errorMessage = Localization.lang("Cannot use port %0 for remote operation; another application may be using it. Try specifying another port.", port);
            LOGGER.error(errorMessage);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("Could not ping server at port {}", (Object)this.port, (Object)e);
            return false;
        }
    }

    public boolean sendCommandLineArguments(String[] args) {
        Protocol protocol = this.openNewConnection();
        try {
            boolean bl;
            protocol.sendMessage(RemoteMessage.SEND_COMMAND_LINE_ARGUMENTS, args);
            Pair<RemoteMessage, Object> response = protocol.receiveMessage();
            boolean bl2 = bl = response.getKey() == RemoteMessage.OK;
            if (protocol != null) {
                protocol.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (protocol != null) {
                    try {
                        protocol.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.debug("Could not send args {} to the server at port {}", new Object[]{String.join((CharSequence)", ", args), this.port, e});
                return false;
            }
        }
    }

    private Protocol openNewConnection() throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(120000);
        socket.connect(new InetSocketAddress(RemotePreferences.getIpAddress(), this.port), 120000);
        return new Protocol(socket);
    }
}

