/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class RemotePreferences {
    private final IntegerProperty port;
    private final BooleanProperty useRemoteServer;

    public RemotePreferences(int port, boolean useRemoteServer) {
        this.port = new SimpleIntegerProperty(port);
        this.useRemoteServer = new SimpleBooleanProperty(useRemoteServer);
    }

    public int getPort() {
        return this.port.getValue();
    }

    public IntegerProperty portProperty() {
        return this.port;
    }

    public void setPort(int port) {
        this.port.setValue((Number)port);
    }

    public boolean useRemoteServer() {
        return this.useRemoteServer.getValue();
    }

    public BooleanProperty useRemoteServerProperty() {
        return this.useRemoteServer;
    }

    public void setUseRemoteServer(boolean useRemoteServer) {
        this.useRemoteServer.setValue(Boolean.valueOf(useRemoteServer));
    }

    public boolean isDifferentPort(int otherPort) {
        return this.getPort() != otherPort;
    }

    public static InetAddress getIpAddress() throws UnknownHostException {
        return InetAddress.getByName("localhost");
    }
}

