/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.quality.consistency;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.logic.quality.consistency.BibliographyConsistencyCheck;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.BibField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.types.EntryType;
import org.jooq.lambda.Unchecked;

public abstract class BibliographyConsistencyCheckResultWriter
implements Closeable {
    protected static final String REQUIRED_FIELD_AT_ENTRY_TYPE_CELL_ENTRY = "x";
    protected static final String OPTIONAL_FIELD_AT_ENTRY_TYPE_CELL_ENTRY = "o";
    protected static final String UNKNOWN_FIELD_AT_ENTRY_TYPE_CELL_ENTRY = "?";
    protected static final String UNSET_FIELD_AT_ENTRY_TYPE_CELL_ENTRY = "-";
    protected final BibliographyConsistencyCheck.Result result;
    protected final Writer writer;
    protected final BibEntryTypesManager entryTypesManager;
    protected final BibDatabaseMode bibDatabaseMode;
    protected final List<String> columnNames;
    protected final int columnCount;
    private final List<Field> allReportedFields;

    public BibliographyConsistencyCheckResultWriter(BibliographyConsistencyCheck.Result result, Writer writer) {
        this(result, writer, new BibEntryTypesManager(), BibDatabaseMode.BIBTEX);
    }

    public BibliographyConsistencyCheckResultWriter(BibliographyConsistencyCheck.Result result, Writer writer, BibEntryTypesManager entryTypesManager, BibDatabaseMode bibDatabaseMode) {
        this.result = result;
        this.writer = writer;
        this.entryTypesManager = entryTypesManager;
        this.bibDatabaseMode = bibDatabaseMode;
        this.allReportedFields = result.entryTypeToResultMap().values().stream().flatMap(entryTypeResult -> entryTypeResult.fields().stream()).sorted(Comparator.comparing(Field::getName)).distinct().toList();
        this.columnNames = this.getColumnNames();
        this.columnCount = this.columnNames.size();
    }

    public void writeFindings() throws IOException {
        this.result.entryTypeToResultMap().entrySet().stream().sorted(Comparator.comparing(entry -> ((EntryType)entry.getKey()).getName())).forEach(Unchecked.consumer(mapEntry -> this.writeMapEntry((Map.Entry<EntryType, BibliographyConsistencyCheck.EntryTypeResult>)mapEntry)));
    }

    private List<String> getColumnNames() {
        ArrayList<String> result = new ArrayList<String>(this.columnCount + 2);
        result.add("entry type");
        result.add("citation key");
        this.allReportedFields.forEach(field -> result.add(field.getDisplayName()));
        return result;
    }

    protected List<String> getFindingsAsList(BibEntry bibEntry, String entryType, Set<Field> requiredFields, Set<Field> optionalFields) {
        ArrayList<String> result = new ArrayList<String>(this.columnCount + 2);
        result.add(entryType);
        result.add(bibEntry.getCitationKey().orElse(""));
        this.allReportedFields.forEach(field -> result.add(bibEntry.getField((Field)field).map(value -> {
            if (requiredFields.contains(field)) {
                return REQUIRED_FIELD_AT_ENTRY_TYPE_CELL_ENTRY;
            }
            if (optionalFields.contains(field)) {
                return OPTIONAL_FIELD_AT_ENTRY_TYPE_CELL_ENTRY;
            }
            return UNKNOWN_FIELD_AT_ENTRY_TYPE_CELL_ENTRY;
        }).orElse(UNSET_FIELD_AT_ENTRY_TYPE_CELL_ENTRY)));
        return result;
    }

    protected void writeMapEntry(Map.Entry<EntryType, BibliographyConsistencyCheck.EntryTypeResult> mapEntry) {
        String entryType = mapEntry.getKey().getDisplayName();
        Optional<BibEntryType> bibEntryType = this.entryTypesManager.enrich(mapEntry.getKey(), this.bibDatabaseMode);
        Set requiredFields = bibEntryType.map(BibEntryType::getRequiredFields).stream().flatMap(orFieldsCollection -> orFieldsCollection.stream()).flatMap(orFields -> orFields.getFields().stream()).collect(Collectors.toSet());
        Set optionalFields = bibEntryType.map(BibEntryType::getOptionalFields).stream().flatMap(bibFieldSet -> bibFieldSet.stream()).map(BibField::field).collect(Collectors.toSet());
        BibliographyConsistencyCheck.EntryTypeResult entries = mapEntry.getValue();
        SequencedCollection<BibEntry> bibEntries = entries.sortedEntries();
        bibEntries.forEach(Unchecked.consumer(bibEntry -> this.writeBibEntry((BibEntry)bibEntry, entryType, requiredFields, optionalFields)));
    }

    protected abstract void writeBibEntry(BibEntry var1, String var2, Set<Field> var3, Set<Field> var4) throws IOException;
}

