/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.pseudonymization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Pseudonymization {
    public Result pseudonymizeLibrary(BibDatabaseContext bibDatabaseContext) {
        HashMap<Field, Map<String, Integer>> fieldToValueToIdMap = new HashMap<Field, Map<String, Integer>>();
        List<BibEntry> newEntries = Pseudonymization.pseudonymizeEntries(bibDatabaseContext, fieldToValueToIdMap);
        HashMap<String, String> valueMapping = new HashMap<String, String>();
        fieldToValueToIdMap.forEach((field, stringToIntMap) -> stringToIntMap.forEach((value, id) -> valueMapping.put(field.getName().toLowerCase(Locale.ROOT) + "-" + id, (String)value)));
        BibDatabase bibDatabase = new BibDatabase(newEntries);
        BibDatabaseContext result = new BibDatabaseContext(bibDatabase);
        result.setMode(bibDatabaseContext.getMode());
        return new Result(result, valueMapping);
    }

    private static List<BibEntry> pseudonymizeEntries(BibDatabaseContext bibDatabaseContext, Map<Field, Map<String, Integer>> fieldToValueToIdMap) {
        List<BibEntry> entries = bibDatabaseContext.getEntries();
        ArrayList<BibEntry> newEntries = new ArrayList<BibEntry>(entries.size());
        for (BibEntry entry : entries) {
            BibEntry newEntry = new BibEntry(entry.getType());
            newEntries.add(newEntry);
            for (Field field : entry.getFields()) {
                Map valueToIdMap = fieldToValueToIdMap.computeIfAbsent(field, k -> new HashMap());
                String fieldContent = entry.getField(field).get();
                Integer id = valueToIdMap.computeIfAbsent(fieldContent, k -> valueToIdMap.size() + 1);
                newEntry.setField(field, field.getName() + "-" + id);
            }
        }
        return newEntries;
    }

    public record Result(BibDatabaseContext bibDatabaseContext, Map<String, String> valueMapping) {
    }
}

