/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.style;

import java.util.Optional;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.logic.openoffice.style.OOProcess;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.Citation;
import org.jabref.model.openoffice.style.CitationGroup;
import org.jabref.model.openoffice.style.CitationGroups;
import org.jabref.model.openoffice.util.OOListUtil;

class OOProcessCitationKeyMarkers {
    private OOProcessCitationKeyMarkers() {
    }

    static void produceCitationMarkers(CitationGroups citationGroups, OOBibStyle style) {
        assert (style.isCitationKeyCiteMarkers());
        citationGroups.createPlainBibliographySortedByComparator(OOProcess.AUTHOR_YEAR_TITLE_COMPARATOR);
        for (CitationGroup group : citationGroups.getCitationGroupsInGlobalOrder()) {
            String citMarker = style.getCitationGroupMarkupBefore() + String.join((CharSequence)",", OOListUtil.map(group.getCitationsInLocalOrder(), Citation::getCitationKey)) + style.getCitationGroupMarkupAfter();
            group.setCitationMarker(Optional.of(OOText.fromString(citMarker)));
        }
    }
}

