/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.logic.openoffice.style.OOProcess;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.Citation;
import org.jabref.model.openoffice.style.CitationGroup;
import org.jabref.model.openoffice.style.CitationGroups;
import org.jabref.model.openoffice.style.CitationMarkerEntry;
import org.jabref.model.openoffice.style.CitationType;
import org.jabref.model.openoffice.style.CitedKey;
import org.jabref.model.openoffice.style.CitedKeys;
import org.jabref.model.openoffice.style.NonUniqueCitationMarker;
import org.jabref.model.openoffice.util.OOListUtil;

class OOProcessAuthorYearMarkers {
    private OOProcessAuthorYearMarkers() {
    }

    private static void createNormalizedCitationMarkers(CitedKeys sortedCitedKeys, OOBibStyle style) {
        for (CitedKey ck : sortedCitedKeys.values()) {
            ck.setNormalizedCitationMarker(Optional.of(style.getNormalizedCitationMarker(ck)));
        }
    }

    private static void createUniqueLetters(CitedKeys sortedCitedKeys, CitationGroups citationGroups) {
        HashMap normCitMarkerToClachingKeys = new HashMap();
        for (CitedKey citedKey : sortedCitedKeys.values()) {
            String normCitMarker = OOText.toString(citedKey.getNormalizedCitationMarker().get());
            String citationKey = citedKey.citationKey;
            List clashingKeys = normCitMarkerToClachingKeys.putIfAbsent(normCitMarker, new ArrayList(1));
            if (clashingKeys == null) {
                clashingKeys = (List)normCitMarkerToClachingKeys.get(normCitMarker);
            }
            if (clashingKeys.contains(citationKey)) continue;
            clashingKeys.add(citationKey);
        }
        for (CitedKey citedKey : sortedCitedKeys.values()) {
            citedKey.setUniqueLetter(Optional.empty());
        }
        for (List clashingKeys : normCitMarkerToClachingKeys.values()) {
            if (clashingKeys.size() <= 1) continue;
            int nextUniqueLetter = 97;
            for (String citationKey : clashingKeys) {
                String uniqueLetter = String.valueOf((char)nextUniqueLetter);
                sortedCitedKeys.get(citationKey).setUniqueLetter(Optional.of(uniqueLetter));
                ++nextUniqueLetter;
            }
        }
        sortedCitedKeys.distributeUniqueLetters(citationGroups);
    }

    private static void setIsFirstAppearanceOfSourceInCitations(CitationGroups citationGroups) {
        HashSet<String> seenBefore = new HashSet<String>();
        for (CitationGroup group : citationGroups.getCitationGroupsInGlobalOrder()) {
            for (Citation cit : group.getCitationsInLocalOrder()) {
                String currentKey = cit.citationKey;
                if (!seenBefore.contains(currentKey)) {
                    cit.setIsFirstAppearanceOfSource(true);
                    seenBefore.add(currentKey);
                    continue;
                }
                cit.setIsFirstAppearanceOfSource(false);
            }
        }
    }

    static void produceCitationMarkers(CitationGroups citationGroups, OOBibStyle style) {
        assert (!style.isCitationKeyCiteMarkers());
        assert (!style.isNumberEntries());
        CitedKeys citedKeys = citationGroups.getCitedKeysSortedInOrderOfAppearance();
        OOProcessAuthorYearMarkers.createNormalizedCitationMarkers(citedKeys, style);
        OOProcessAuthorYearMarkers.createUniqueLetters(citedKeys, citationGroups);
        citationGroups.createPlainBibliographySortedByComparator(OOProcess.AUTHOR_YEAR_TITLE_COMPARATOR);
        OOProcessAuthorYearMarkers.setIsFirstAppearanceOfSourceInCitations(citationGroups);
        for (CitationGroup group : citationGroups.getCitationGroupsInGlobalOrder()) {
            boolean inParenthesis = group.citationType == CitationType.AUTHORYEAR_PAR;
            NonUniqueCitationMarker strictlyUnique = NonUniqueCitationMarker.THROWS;
            List<Citation> cits = group.getCitationsInLocalOrder();
            List<CitationMarkerEntry> citationMarkerEntries = OOListUtil.map(cits, e -> e);
            OOText citMarker = style.createCitationMarker(citationMarkerEntries, inParenthesis, strictlyUnique);
            group.setCitationMarker(Optional.of(citMarker));
        }
    }
}

