/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.frontend;

import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import java.util.Optional;
import org.jabref.logic.openoffice.frontend.OOFrontend;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.logic.openoffice.style.OOFormatBibliography;
import org.jabref.model.openoffice.DocumentAnnotation;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.ootext.OOTextIntoOO;
import org.jabref.model.openoffice.style.CitedKeys;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoBookmark;
import org.jabref.model.openoffice.uno.UnoTextSection;

public class UpdateBibliography {
    private static final String BIB_SECTION_NAME = "JR_bib";
    private static final String BIB_SECTION_END_NAME = "JR_bib_end";

    private UpdateBibliography() {
    }

    public static Optional<XTextRange> getBibliographyRange(XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        return UnoTextSection.getAnchor(doc, BIB_SECTION_NAME);
    }

    public static void rebuildBibTextSection(XTextDocument doc, OOFrontend frontend, CitedKeys bibliography, OOBibStyle style, boolean alwaysAddCitedOnPages) throws WrappedTargetException, CreationException, NoDocumentException {
        UpdateBibliography.clearBibTextSectionContent2(doc);
        UpdateBibliography.populateBibTextSection(doc, frontend, bibliography, style, alwaysAddCitedOnPages);
    }

    private static void createBibTextSection2(XTextDocument doc) throws CreationException {
        XTextCursor textCursor = doc.getText().createTextCursor();
        textCursor.gotoEnd(false);
        DocumentAnnotation annotation = new DocumentAnnotation(doc, BIB_SECTION_NAME, (XTextRange)textCursor, false);
        UnoTextSection.create(annotation);
    }

    private static void clearBibTextSectionContent2(XTextDocument doc) throws CreationException, NoDocumentException, WrappedTargetException {
        Optional<XTextRange> sectionRange = UpdateBibliography.getBibliographyRange(doc);
        if (sectionRange.isEmpty()) {
            UpdateBibliography.createBibTextSection2(doc);
        } else {
            XTextCursor cursor = doc.getText().createTextCursorByRange(sectionRange.get());
            cursor.setString("");
        }
    }

    private static void populateBibTextSection(XTextDocument doc, OOFrontend frontend, CitedKeys bibliography, OOBibStyle style, boolean alwaysAddCitedOnPages) throws CreationException, IllegalArgumentException, NoDocumentException, WrappedTargetException {
        XTextRange sectionRange = UpdateBibliography.getBibliographyRange(doc).orElseThrow(IllegalStateException::new);
        XTextCursor cursor = doc.getText().createTextCursorByRange(sectionRange);
        OOTextIntoOO.removeDirectFormatting(cursor);
        OOText bibliographyText = OOFormatBibliography.formatBibliography(frontend.citationGroups, bibliography, style, alwaysAddCitedOnPages);
        OOTextIntoOO.write(doc, cursor, bibliographyText);
        cursor.collapseToEnd();
        sectionRange = UpdateBibliography.getBibliographyRange(doc).orElseThrow(IllegalStateException::new);
        XTextCursor initialParagraph = doc.getText().createTextCursorByRange(sectionRange);
        initialParagraph.collapseToStart();
        initialParagraph.goRight((short)1, true);
        initialParagraph.setString("");
        UnoBookmark.removeIfExists(doc, BIB_SECTION_END_NAME);
        DocumentAnnotation documentAnnotation = new DocumentAnnotation(doc, BIB_SECTION_END_NAME, (XTextRange)cursor, true);
        UnoBookmark.create(documentAnnotation);
        cursor.collapseToEnd();
    }
}

