/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.msbib;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import org.jabref.logic.msbib.MSBibEntryType;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.IEEETranEntryType;
import org.jabref.model.entry.types.StandardEntryType;

public class MSBibMapping {
    private static final String BIBTEX_PREFIX = "BIBTEX_";
    private static final String MSBIB_PREFIX = "msbib-";
    private static final BiMap<String, Integer> LANG_TO_LCID = HashBiMap.create();
    private static final BiMap<Field, String> BIBLATEX_TO_MS_BIB = HashBiMap.create();
    private static final Map<String, EntryType> MSBIB_ENTRYTYPE_MAPPING;
    private static final Map<EntryType, MSBibEntryType> BIB_ENTRYTYPE_MAPPING;

    private MSBibMapping() {
    }

    public static EntryType getBiblatexEntryType(String msbibType) {
        return MSBIB_ENTRYTYPE_MAPPING.getOrDefault(msbibType, StandardEntryType.Misc);
    }

    public static MSBibEntryType getMSBibEntryType(EntryType bibtexType) {
        return BIB_ENTRYTYPE_MAPPING.getOrDefault(bibtexType, MSBibEntryType.Misc);
    }

    public static int getLCID(String language) {
        return (Integer)LANG_TO_LCID.getOrDefault((Object)language, (Object)1033);
    }

    public static String getLanguage(int LCID) {
        return (String)LANG_TO_LCID.inverse().getOrDefault((Object)LCID, (Object)"english");
    }

    public static String getMSBibField(Field field) {
        return (String)BIBLATEX_TO_MS_BIB.get((Object)field);
    }

    public static Field getBibTeXField(String msbibFieldName) {
        return (Field)BIBLATEX_TO_MS_BIB.inverse().get((Object)msbibFieldName);
    }

    static {
        BIB_ENTRYTYPE_MAPPING = new HashMap<EntryType, MSBibEntryType>();
        LANG_TO_LCID.put((Object)"basque", (Object)1609);
        LANG_TO_LCID.put((Object)"bulgarian", (Object)1026);
        LANG_TO_LCID.put((Object)"catalan", (Object)1027);
        LANG_TO_LCID.put((Object)"croatian", (Object)1050);
        LANG_TO_LCID.put((Object)"czech", (Object)1029);
        LANG_TO_LCID.put((Object)"danish", (Object)1030);
        LANG_TO_LCID.put((Object)"dutch", (Object)1043);
        LANG_TO_LCID.put((Object)"english", (Object)1033);
        LANG_TO_LCID.put((Object)"finnish", (Object)1035);
        LANG_TO_LCID.put((Object)"french", (Object)1036);
        LANG_TO_LCID.put((Object)"german", (Object)1031);
        LANG_TO_LCID.put((Object)"austrian", (Object)3079);
        LANG_TO_LCID.put((Object)"swissgerman", (Object)2055);
        LANG_TO_LCID.put((Object)"greek", (Object)1032);
        LANG_TO_LCID.put((Object)"hungarian", (Object)1038);
        LANG_TO_LCID.put((Object)"icelandic", (Object)1039);
        LANG_TO_LCID.put((Object)"italian", (Object)1040);
        LANG_TO_LCID.put((Object)"latvian", (Object)1062);
        LANG_TO_LCID.put((Object)"lithuanian", (Object)1063);
        LANG_TO_LCID.put((Object)"marathi", (Object)1102);
        LANG_TO_LCID.put((Object)"nynorsk", (Object)2068);
        LANG_TO_LCID.put((Object)"polish", (Object)1045);
        LANG_TO_LCID.put((Object)"brazil", (Object)1046);
        LANG_TO_LCID.put((Object)"portuguese", (Object)2070);
        LANG_TO_LCID.put((Object)"romanian", (Object)1048);
        LANG_TO_LCID.put((Object)"russian", (Object)1049);
        LANG_TO_LCID.put((Object)"serbian", (Object)2074);
        LANG_TO_LCID.put((Object)"serbianc", (Object)3098);
        LANG_TO_LCID.put((Object)"slovak", (Object)1051);
        LANG_TO_LCID.put((Object)"slovene", (Object)1060);
        LANG_TO_LCID.put((Object)"spanish", (Object)3082);
        LANG_TO_LCID.put((Object)"swedish", (Object)1053);
        LANG_TO_LCID.put((Object)"turkish", (Object)1055);
        LANG_TO_LCID.put((Object)"ukrainian", (Object)1058);
        BIBLATEX_TO_MS_BIB.put((Object)InternalField.KEY_FIELD, (Object)"Tag");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.TITLE, (Object)"Title");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.YEAR, (Object)"Year");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.VOLUME, (Object)"Volume");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.LANGUAGE, (Object)"LCID");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.EDITION, (Object)"Edition");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.PUBLISHER, (Object)"Publisher");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.BOOKTITLE, (Object)"BookTitle");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.SHORTTITLE, (Object)"ShortTitle");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.NOTE, (Object)"Comments");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.VOLUMES, (Object)"NumberVolumes");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.CHAPTER, (Object)"ChapterNumber");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.ISSUE, (Object)"Issue");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.SCHOOL, (Object)"Department");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.INSTITUTION, (Object)"Institution");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.DOI, (Object)"DOI");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.URL, (Object)"URL");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.SERIES, (Object)"BIBTEX_Series");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.ABSTRACT, (Object)"BIBTEX_Abstract");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.KEYWORDS, (Object)"BIBTEX_KeyWords");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.CROSSREF, (Object)"BIBTEX_CrossRef");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.HOWPUBLISHED, (Object)"BIBTEX_HowPublished");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.PUBSTATE, (Object)"BIBTEX_Pubstate");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("affiliation"), (Object)"BIBTEX_Affiliation");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("contents"), (Object)"BIBTEX_Contents");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("copyright"), (Object)"BIBTEX_Copyright");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("price"), (Object)"BIBTEX_Price");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("size"), (Object)"BIBTEX_Size");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("intype"), (Object)"BIBTEX_InType");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("paper"), (Object)"BIBTEX_Paper");
        BIBLATEX_TO_MS_BIB.put((Object)StandardField.KEY, (Object)"BIBTEX_Key");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-periodical"), (Object)"PeriodicalTitle");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField(MSBIB_PREFIX + String.valueOf(StandardField.DAY)), (Object)"Day");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-accessed"), (Object)"Accessed");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-medium"), (Object)"Medium");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-recordingnumber"), (Object)"RecordingNumber");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-theater"), (Object)"Theater");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-distributor"), (Object)"Distributor");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-broadcaster"), (Object)"Broadcaster");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-station"), (Object)"Station");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField(MSBIB_PREFIX + String.valueOf(StandardField.TYPE)), (Object)"Type");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-court"), (Object)"Court");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-reporter"), (Object)"Reporter");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-casenumber"), (Object)"CaseNumber");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-abbreviatedcasenumber"), (Object)"AbbreviatedCaseNumber");
        BIBLATEX_TO_MS_BIB.put((Object)new UnknownField("msbib-productioncompany"), (Object)"ProductionCompany");
        MSBIB_ENTRYTYPE_MAPPING = Map.of("Book", StandardEntryType.Book, "BookSection", StandardEntryType.Book, "JournalArticle", StandardEntryType.Article, "ArticleInAPeriodical", IEEETranEntryType.Periodical, "ConferenceProceedings", StandardEntryType.InProceedings, "Report", StandardEntryType.TechReport, "Patent", IEEETranEntryType.Patent, "InternetSite", StandardEntryType.Online);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Book, MSBibEntryType.Book);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.InBook, MSBibEntryType.BookSection);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Booklet, MSBibEntryType.BookSection);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.InCollection, MSBibEntryType.BookSection);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Article, MSBibEntryType.JournalArticle);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.InProceedings, MSBibEntryType.ConferenceProceedings);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Conference, MSBibEntryType.ConferenceProceedings);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Proceedings, MSBibEntryType.ConferenceProceedings);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Collection, MSBibEntryType.ConferenceProceedings);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.TechReport, MSBibEntryType.Report);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Manual, MSBibEntryType.Report);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.MastersThesis, MSBibEntryType.Report);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.PhdThesis, MSBibEntryType.Report);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Unpublished, MSBibEntryType.Report);
        BIB_ENTRYTYPE_MAPPING.put(IEEETranEntryType.Patent, MSBibEntryType.Patent);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Misc, MSBibEntryType.Misc);
        BIB_ENTRYTYPE_MAPPING.put(IEEETranEntryType.Electronic, MSBibEntryType.ElectronicSource);
        BIB_ENTRYTYPE_MAPPING.put(StandardEntryType.Online, MSBibEntryType.InternetSite);
    }
}

