/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.layout.LayoutFormatter;

public class Ordinal
implements LayoutFormatter {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(1?\\d\\b)");

    @Override
    public String format(String fieldText) {
        if (fieldText == null) {
            return null;
        }
        Matcher m = NUMBER_PATTERN.matcher(fieldText);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String result = m.group(1);
            int value = Integer.parseInt(result);
            String ordinalString = switch (value) {
                case 1 -> "st";
                case 2 -> "nd";
                case 3 -> "rd";
                default -> "th";
            };
            m.appendReplacement(sb, result + ordinalString);
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

