/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.journals;

import java.io.Serializable;
import java.util.Objects;

public class Abbreviation
implements Comparable<Abbreviation>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient String name;
    private final String abbreviation;
    private transient String dotlessAbbreviation;
    private String shortestUniqueAbbreviation;

    public Abbreviation(String name, String abbreviation) {
        this(name, abbreviation, "");
    }

    public Abbreviation(String name, String abbreviation, String shortestUniqueAbbreviation) {
        this(name, abbreviation, abbreviation.replace(".", " ").replace("  ", " ").trim(), shortestUniqueAbbreviation.trim());
    }

    private Abbreviation(String name, String abbreviation, String dotlessAbbreviation, String shortestUniqueAbbreviation) {
        this.name = name.intern();
        this.abbreviation = abbreviation.intern();
        this.dotlessAbbreviation = dotlessAbbreviation.intern();
        this.shortestUniqueAbbreviation = shortestUniqueAbbreviation.trim().intern();
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getShortestUniqueAbbreviation() {
        if (this.shortestUniqueAbbreviation.isEmpty()) {
            this.shortestUniqueAbbreviation = this.getAbbreviation();
        }
        return this.shortestUniqueAbbreviation;
    }

    public boolean isDefaultShortestUniqueAbbreviation() {
        return this.shortestUniqueAbbreviation.isEmpty() || this.shortestUniqueAbbreviation.equals(this.abbreviation);
    }

    public String getDotlessAbbreviation() {
        return this.dotlessAbbreviation;
    }

    @Override
    public int compareTo(Abbreviation toCompare) {
        int nameComparison = this.getName().compareTo(toCompare.getName());
        if (nameComparison != 0) {
            return nameComparison;
        }
        int abbreviationComparison = this.getAbbreviation().compareTo(toCompare.getAbbreviation());
        if (abbreviationComparison != 0) {
            return abbreviationComparison;
        }
        return this.getShortestUniqueAbbreviation().compareTo(toCompare.getShortestUniqueAbbreviation());
    }

    public String getNext(String current) {
        String currentTrimmed = current.trim();
        if (this.getDotlessAbbreviation().equals(currentTrimmed)) {
            return this.getShortestUniqueAbbreviation().equals(this.getAbbreviation()) ? this.getName() : this.getShortestUniqueAbbreviation();
        }
        if (this.getShortestUniqueAbbreviation().equals(currentTrimmed) && !this.getShortestUniqueAbbreviation().equals(this.getAbbreviation())) {
            return this.getName();
        }
        if (this.getName().equals(currentTrimmed)) {
            return this.getAbbreviation();
        }
        return this.getDotlessAbbreviation();
    }

    public String toString() {
        return "Abbreviation{name=%s, abbreviation=%s, dotlessAbbreviation=%s, shortestUniqueAbbreviation=%s}".formatted(this.name, this.abbreviation, this.dotlessAbbreviation, this.shortestUniqueAbbreviation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Abbreviation that = (Abbreviation)o;
        return this.getName().equals(that.getName()) && this.getAbbreviation().equals(that.getAbbreviation()) && this.getShortestUniqueAbbreviation().equals(that.getShortestUniqueAbbreviation());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAbbreviation(), this.getShortestUniqueAbbreviation());
    }
}

