/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.BibField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.BiblatexEntryTypeDefinitions;
import org.jabref.model.entry.types.BibtexEntryTypeDefinitions;

public class NoBibtexFieldChecker
implements EntryChecker {
    private Set<Field> getAllBiblatexOnlyFields() {
        Set allBibtexFields = BibtexEntryTypeDefinitions.ALL.stream().flatMap(type -> type.getAllBibFields().stream()).collect(Collectors.toSet());
        return BiblatexEntryTypeDefinitions.ALL.stream().flatMap(type -> type.getAllBibFields().stream()).filter(field -> !allBibtexFields.contains(field)).map(BibField::field).filter(field -> !field.equals(StandardField.ABSTRACT)).filter(field -> !field.equals(StandardField.COMMENT)).filter(field -> !field.equals(StandardField.DOI)).filter(field -> !field.equals(StandardField.URL)).collect(Collectors.toSet());
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Set<Field> allBiblatexOnlyFields = this.getAllBiblatexOnlyFields();
        return entry.getFields().stream().filter(allBiblatexOnlyFields::contains).map(name -> new IntegrityMessage(Localization.lang("biblatex field only", new Object[0]), entry, (Field)name)).collect(Collectors.toList());
    }
}

