/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;

public class ASCIICharacterChecker
implements EntryChecker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> results = new ArrayList<IntegrityMessage>();
        for (Map.Entry<Field, String> field : entry.getFieldMap().entrySet()) {
            boolean asciiOnly = CharMatcher.ascii().matchesAllOf((CharSequence)field.getValue());
            if (asciiOnly) continue;
            results.add(new IntegrityMessage(Localization.lang("Non-ASCII encoded character found", new Object[0]), entry, field.getKey()));
        }
        return results;
    }
}

