/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;

public class EndnoteImporter
extends Importer {
    private static final String ENDOFRECORD = "__EOREOR__";
    private static final Pattern A_PATTERN = Pattern.compile("%A .*");
    private static final Pattern E_PATTERN = Pattern.compile("%E .*");

    @Override
    public String getName() {
        return "Refer/Endnote";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.ENDNOTE;
    }

    @Override
    public String getId() {
        return "refer";
    }

    @Override
    public String getDescription() {
        return "Importer for the Refer/Endnote format. Modified to use article number for pages if pages are missing.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (!A_PATTERN.matcher(str).matches() && !E_PATTERN.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while ((str = reader.readLine()) != null) {
            if ((str = str.trim()).indexOf("%0") == 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append(ENDOFRECORD);
                }
                sb.append(str);
            } else {
                sb.append(str);
            }
            sb.append('\n');
        }
        String[] entries = sb.toString().split(ENDOFRECORD);
        HashMap<Field, String> hm = new HashMap<Field, String>();
        for (String entry : entries) {
            String[] fields;
            hm.clear();
            StringBuilder author = new StringBuilder();
            EntryType type = BibEntry.DEFAULT_TYPE;
            StringBuilder editor = new StringBuilder();
            String artnum = "";
            boolean isEditedBook = false;
            block48: for (String field : fields = entry.trim().substring(1).split("\n%")) {
                if (field.length() < 3) continue;
                String prefix = field.substring(0, 1);
                String val = field.substring(2);
                switch (prefix) {
                    case "A": {
                        if (author.isEmpty()) {
                            author = new StringBuilder(val);
                            continue block48;
                        }
                        author.append(" and ").append(val);
                        continue block48;
                    }
                    case "E": {
                        if (editor.isEmpty()) {
                            editor = new StringBuilder(val);
                            continue block48;
                        }
                        editor.append(" and ").append(val);
                        continue block48;
                    }
                    case "T": {
                        hm.put(StandardField.TITLE, val);
                        continue block48;
                    }
                    case "0": {
                        if (val.indexOf("Journal") == 0) {
                            type = StandardEntryType.Article;
                            continue block48;
                        }
                        if (val.indexOf("Book Section") == 0) {
                            type = StandardEntryType.InCollection;
                            continue block48;
                        }
                        if (val.indexOf("Book") == 0) {
                            type = StandardEntryType.Book;
                            continue block48;
                        }
                        if (val.indexOf("Edited Book") == 0) {
                            type = StandardEntryType.Book;
                            isEditedBook = true;
                            continue block48;
                        }
                        if (val.indexOf("Conference") == 0) {
                            type = StandardEntryType.InProceedings;
                            continue block48;
                        }
                        if (val.indexOf("Report") == 0) {
                            type = StandardEntryType.TechReport;
                            continue block48;
                        }
                        if (val.indexOf("Review") == 0) {
                            type = StandardEntryType.Article;
                            continue block48;
                        }
                        if (val.indexOf("Thesis") == 0) {
                            type = StandardEntryType.PhdThesis;
                            continue block48;
                        }
                        type = BibEntry.DEFAULT_TYPE;
                        continue block48;
                    }
                    case "7": {
                        hm.put(StandardField.EDITION, val);
                        continue block48;
                    }
                    case "C": {
                        hm.put(StandardField.ADDRESS, val);
                        continue block48;
                    }
                    case "D": {
                        hm.put(StandardField.YEAR, val);
                        continue block48;
                    }
                    case "8": {
                        hm.put(StandardField.DATE, val);
                        continue block48;
                    }
                    case "J": {
                        hm.putIfAbsent(StandardField.JOURNAL, val);
                        continue block48;
                    }
                    case "B": {
                        if (type.equals(StandardEntryType.Article)) {
                            hm.put(StandardField.JOURNAL, val);
                            continue block48;
                        }
                        if (type.equals(StandardEntryType.Book) || type.equals(StandardEntryType.InBook)) {
                            hm.put(StandardField.SERIES, val);
                            continue block48;
                        }
                        hm.put(StandardField.BOOKTITLE, val);
                        continue block48;
                    }
                    case "I": {
                        if (type.equals(StandardEntryType.PhdThesis)) {
                            hm.put(StandardField.SCHOOL, val);
                            continue block48;
                        }
                        hm.put(StandardField.PUBLISHER, val);
                        continue block48;
                    }
                    case "P": {
                        hm.put(StandardField.PAGES, val.replaceAll("([0-9]) *- *([0-9])", "$1--$2"));
                        continue block48;
                    }
                    case "V": {
                        hm.put(StandardField.VOLUME, val);
                        continue block48;
                    }
                    case "N": {
                        hm.put(StandardField.NUMBER, val);
                        continue block48;
                    }
                    case "U": {
                        hm.put(StandardField.URL, val);
                        continue block48;
                    }
                    case "R": {
                        String doi = val;
                        if (doi.startsWith("doi:")) {
                            doi = doi.substring(4);
                        }
                        hm.put(StandardField.DOI, doi);
                        continue block48;
                    }
                    case "O": {
                        if (val.startsWith("Artn")) {
                            String[] tokens = val.split("\\s");
                            artnum = tokens[1];
                            continue block48;
                        }
                        hm.put(StandardField.NOTE, val);
                        continue block48;
                    }
                    case "K": {
                        hm.put(StandardField.KEYWORDS, val);
                        continue block48;
                    }
                    case "X": {
                        hm.put(StandardField.ABSTRACT, val);
                        continue block48;
                    }
                    case "9": {
                        if (val.indexOf("Ph.D.") == 0) {
                            type = StandardEntryType.PhdThesis;
                        }
                        if (val.indexOf("Masters") != 0) continue block48;
                        type = StandardEntryType.MastersThesis;
                        continue block48;
                    }
                    case "F": {
                        hm.put(InternalField.KEY_FIELD, CitationKeyGenerator.cleanKey(val, ""));
                    }
                }
            }
            if (isEditedBook && editor.toString().isEmpty()) {
                editor = new StringBuilder(author.toString());
                author = new StringBuilder();
            }
            if (!"".contentEquals(author)) {
                hm.put(StandardField.AUTHOR, EndnoteImporter.fixAuthor(author.toString()));
            }
            if (!"".contentEquals(editor)) {
                hm.put(StandardField.EDITOR, EndnoteImporter.fixAuthor(editor.toString()));
            }
            if ((hm.get(StandardField.PAGES) == null || "-".equals(hm.get(StandardField.PAGES))) && !"".equals(artnum)) {
                hm.put(StandardField.PAGES, artnum);
            }
            BibEntry b = new BibEntry(type);
            b.setField(hm);
            if (b.getFields().isEmpty()) continue;
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }

    private static String fixAuthor(String s) {
        int index = s.indexOf(" and ");
        if (index >= 0) {
            return AuthorList.fixAuthorLastNameFirst(s);
        }
        index = s.lastIndexOf(44);
        if (index == s.length() - 1) {
            String mod = s.substring(0, s.length() - 1).replace(", ", " and ");
            return AuthorList.fixAuthorLastNameFirst(mod);
        }
        return AuthorList.fixAuthorLastNameFirst(s);
    }
}

