/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.exporter.CffExporter;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.BiblatexSoftwareField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;

public class CffImporter
extends Importer {
    public static final Map<String, Field> FIELDS_MAP = HashBiMap.create(CffExporter.FIELDS_MAP).inverse();
    public static final Map<String, EntryType> TYPES_MAP = HashBiMap.create(CffExporter.TYPES_MAP).inverse();
    private final CitationKeyPatternPreferences citationKeyPatternPreferences;

    public CffImporter(CitationKeyPatternPreferences citationKeyPatternPreferences) {
        this.citationKeyPatternPreferences = citationKeyPatternPreferences;
    }

    @Override
    public String getName() {
        return "CFF";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.CFF;
    }

    @Override
    public String getId() {
        return "cff";
    }

    @Override
    public String getDescription() {
        return "Importer for the CFF format, which is intended to make software and datasets citable.";
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        List<CffIdentifier> doiIds;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        CffFormat citation = (CffFormat)mapper.readValue((Reader)reader, CffFormat.class);
        ArrayList<BibEntry> entriesList = new ArrayList<BibEntry>();
        citation.values.remove("cff-version");
        HashMap<Field, String> entryMap = new HashMap<Field, String>();
        EntryType entryType = TYPES_MAP.getOrDefault(citation.values.get("type"), StandardEntryType.Software);
        citation.values.remove("type");
        entryMap.put(StandardField.AUTHOR, this.parseAuthors(citation.authors));
        if (citation.keywords != null) {
            entryMap.put(StandardField.KEYWORDS, String.join((CharSequence)", ", citation.keywords));
        }
        this.parseFields(citation.values, entryMap);
        if (entryMap.get(StandardField.DOI) == null && citation.ids != null && (doiIds = citation.ids.stream().filter(id -> "doi".equals(id.type)).toList()).size() == 1) {
            entryMap.put(StandardField.DOI, doiIds.getFirst().value);
        }
        if (citation.ids != null) {
            List<String> relSwhIds;
            List<String> swhIds = citation.ids.stream().filter(id -> "swh".equals(id.type)).map(id -> id.value).toList();
            if (swhIds.size() == 1) {
                entryMap.put(BiblatexSoftwareField.SWHID, swhIds.getFirst());
            } else if (swhIds.size() > 1 && (relSwhIds = swhIds.stream().filter(id -> id.split(":").length > 3).filter(id -> "rel".equals(id.split(":")[2])).toList()).size() == 1) {
                entryMap.put(BiblatexSoftwareField.SWHID, relSwhIds.getFirst());
            }
        }
        BibEntry entry = new BibEntry(entryType);
        entry.setField(entryMap);
        entriesList.add(entry);
        BibEntry preferred = null;
        List<BibEntry> references = null;
        if (citation.preferred != null) {
            preferred = this.parseEntry(citation.preferred);
            entriesList.add(preferred);
        }
        if (citation.references != null) {
            references = citation.references.stream().map(this::parseEntry).toList();
            entriesList.addAll(references);
        }
        ParserResult res = new ParserResult(entriesList);
        CitationKeyGenerator gen = new CitationKeyGenerator(res.getDatabaseContext(), this.citationKeyPatternPreferences);
        if (preferred != null) {
            gen.generateAndSetKey(preferred);
            entry.setField(StandardField.CITES, preferred.getCitationKey().orElse(""));
        }
        if (references != null) {
            references.forEach(ref -> {
                gen.generateAndSetKey((BibEntry)ref);
                String citeKey = ref.getCitationKey().orElse("");
                String related = entry.getField(StandardField.RELATED).orElse("");
                entry.setField(StandardField.RELATED, (String)(related.isEmpty() ? citeKey : related + "," + citeKey));
            });
        }
        return res;
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            CffFormat citation = (CffFormat)mapper.readValue((Reader)reader, CffFormat.class);
            return citation != null && citation.values.get("title") != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String parseAuthors(List<CffEntity> authors) {
        return authors.stream().map(author -> author.values).map(vals -> vals.get("name") != null ? new Author((String)vals.get("name"), "", "", "", "") : new Author((String)vals.get("given-names"), null, (String)vals.get("name-particle"), (String)vals.get("family-names"), (String)vals.get("name-suffix"))).collect(AuthorList.collect()).getAsFirstLastNamesWithAnd();
    }

    private BibEntry parseEntry(CffReference reference) {
        HashMap<Field, String> entryMap = new HashMap<Field, String>();
        EntryType entryType = TYPES_MAP.getOrDefault(reference.type, StandardEntryType.Article);
        entryMap.put(StandardField.AUTHOR, this.parseAuthors(reference.authors));
        this.parseFields(reference.values, entryMap);
        BibEntry entry = new BibEntry(entryType);
        entry.setField(entryMap);
        return entry;
    }

    private void parseFields(Map<String, String> values, Map<Field, String> entryMap) {
        for (Map.Entry<String, String> property : values.entrySet()) {
            if (FIELDS_MAP.containsKey(property.getKey())) {
                entryMap.put(FIELDS_MAP.get(property.getKey()), property.getValue());
                continue;
            }
            entryMap.put(new UnknownField(property.getKey()), property.getValue());
        }
    }

    private static class CffFormat {
        private final HashMap<String, String> values = new HashMap();
        @JsonProperty(value="authors")
        private List<CffEntity> authors;
        @JsonProperty(value="identifiers")
        private List<CffIdentifier> ids;
        @JsonProperty(value="keywords")
        private List<String> keywords;
        @JsonProperty(value="preferred-citation")
        private CffReference preferred;
        @JsonProperty(value="references")
        private List<CffReference> references;

        @JsonAnySetter
        private void setValues(String key, String value) {
            this.values.put(key, value);
        }
    }

    private static class CffIdentifier {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="value")
        private String value;
    }

    private static class CffReference {
        private final HashMap<String, String> values = new HashMap();
        @JsonProperty(value="authors")
        private List<CffEntity> authors;
        @JsonProperty(value="conference")
        private CffEntity conference;
        @JsonProperty(value="contact")
        private CffEntity contact;
        @JsonProperty(value="editors")
        private List<CffEntity> editors;
        @JsonProperty(value="editors-series")
        private List<CffEntity> editorsSeries;
        @JsonProperty(value="database-provider")
        private CffEntity databaseProvider;
        @JsonProperty(value="institution")
        private CffEntity institution;
        @JsonProperty(value="keywords")
        private List<String> keywords;
        @JsonProperty(value="languages")
        private List<String> languages;
        @JsonProperty(value="location")
        private CffEntity location;
        @JsonProperty(value="publisher")
        private CffEntity publisher;
        @JsonProperty(value="recipients")
        private List<CffEntity> recipients;
        @JsonProperty(value="senders")
        private List<CffEntity> senders;
        @JsonProperty(value="translators")
        private List<CffEntity> translators;
        @JsonProperty(value="type")
        private String type;

        @JsonAnySetter
        private void setValues(String key, String value) {
            this.values.put(key, value);
        }
    }

    private static class CffEntity {
        private final HashMap<String, String> values = new HashMap();

        @JsonAnySetter
        private void setValues(String key, String value) {
            this.values.put(key, value);
        }
    }
}

