/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.transformers;

import org.jabref.logic.importer.fetcher.transformers.AbstractQueryTransformer;

public class LOBIDQueryTransformer
extends AbstractQueryTransformer {
    @Override
    public String getLogicalAndOperator() {
        return " AND ";
    }

    @Override
    public String getLogicalOrOperator() {
        return " OR ";
    }

    @Override
    protected String getLogicalNotOperator() {
        return "-";
    }

    @Override
    protected String handleAuthor(String author) {
        return this.createKeyValuePair("contribution.agent.label", author);
    }

    @Override
    protected String handleTitle(String title) {
        return this.createKeyValuePair("title", title);
    }

    @Override
    protected String handleJournal(String journalTitle) {
        return this.createKeyValuePair("bibliographicCitation", journalTitle);
    }

    @Override
    protected String handleYear(String year) {
        return "publication.startDate:[" + year + " TO " + year + "]";
    }

    @Override
    protected String handleYearRange(String yearRange) {
        this.parseYearRange(yearRange);
        if (this.endYear == Integer.MAX_VALUE) {
            return yearRange;
        }
        return "publication.startDate:[" + this.startYear + " TO " + this.endYear + "]";
    }
}

