/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.transformers;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.importer.fetcher.transformers.YearRangeByFilteringQueryTransformer;
import org.jabref.model.entry.AuthorList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISIDOREQueryTransformer
extends YearRangeByFilteringQueryTransformer {
    public static final int MAX_TERMS = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(ISIDOREQueryTransformer.class);
    private int handleCountTitle = 0;
    private int handleCountAuthor = 0;
    private int handleUnfieldedTermCount = 0;
    private Map<String, String> parameterMap = new HashMap<String, String>();

    @Override
    protected String getLogicalAndOperator() {
        return "+AND+";
    }

    @Override
    protected String getLogicalOrOperator() {
        return "+OR+";
    }

    @Override
    protected String getLogicalNotOperator() {
        return "+NOT+";
    }

    @Override
    protected String handleAuthor(String author) {
        ++this.handleCountAuthor;
        if (this.handleCountAuthor > 3) {
            return "";
        }
        String lastFirst = AuthorList.fixAuthorLastNameFirstCommas(author, false, true);
        lastFirst = lastFirst.replace(", ", "_").toLowerCase(Locale.ENGLISH);
        this.parameterMap.put("author", lastFirst);
        return "";
    }

    @Override
    protected String handleTitle(String title) {
        ++this.handleCountTitle;
        if (this.handleCountTitle > 3) {
            return "";
        }
        return this.handleUnFieldedTerm(title).orElse("");
    }

    @Override
    protected String handleJournal(String journalTitle) {
        LOGGER.warn("ISIDORE does not support searching by journal");
        return this.handleUnFieldedTerm(journalTitle).orElse("");
    }

    @Override
    protected String handleYear(String year) {
        this.parameterMap.put("date", year);
        return "";
    }

    @Override
    protected Optional<String> handleUnFieldedTerm(String term) {
        if (Word.SMALLER_WORDS.contains(term)) {
            return Optional.empty();
        }
        if (!term.matches("\\w+")) {
            return Optional.empty();
        }
        ++this.handleUnfieldedTermCount;
        if (this.handleUnfieldedTermCount > 4) {
            return Optional.empty();
        }
        return super.handleUnFieldedTerm(term);
    }

    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    protected Optional<String> handleOtherField(String fieldAsString, String term) {
        Optional<String> first = this.handleUnFieldedTerm(fieldAsString);
        Optional<String> second = this.handleUnFieldedTerm(term);
        if (first.isEmpty() && second.isEmpty()) {
            return Optional.empty();
        }
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        return Optional.of(fieldAsString + " " + term);
    }
}

