/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.transformers;

import java.util.Optional;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.importer.fetcher.transformers.YearRangeByFilteringQueryTransformer;
import org.jabref.model.strings.StringUtil;

public class IEEEQueryTransformer
extends YearRangeByFilteringQueryTransformer {
    private String journal;
    private String articleNumber;

    @Override
    protected String getLogicalAndOperator() {
        return " AND ";
    }

    @Override
    protected String getLogicalOrOperator() {
        return " OR ";
    }

    @Override
    protected String getLogicalNotOperator() {
        return "NOT ";
    }

    @Override
    protected String handleAuthor(String author) {
        return this.createKeyValuePair("author", author);
    }

    @Override
    protected String handleTitle(String title) {
        return this.createKeyValuePair("article_title", title);
    }

    @Override
    protected String handleJournal(String journal) {
        this.journal = journal;
        return StringUtil.quoteStringIfSpaceIsContained(journal);
    }

    @Override
    protected String handleYear(String year) {
        this.startYear = Math.min(this.startYear, Integer.parseInt(year));
        this.endYear = Math.max(this.endYear, Integer.parseInt(year));
        return "";
    }

    @Override
    protected Optional<String> handleOtherField(String fieldAsString, String term) {
        return switch (fieldAsString) {
            case "article_number" -> this.handleArticleNumber(term);
            default -> super.handleOtherField(fieldAsString, term);
        };
    }

    @Override
    protected Optional<String> handleUnFieldedTerm(String term) {
        if (Word.SMALLER_WORDS.contains(term)) {
            return Optional.empty();
        }
        return super.handleUnFieldedTerm(term);
    }

    private Optional<String> handleArticleNumber(String term) {
        this.articleNumber = term;
        return Optional.empty();
    }

    public Optional<String> getJournal() {
        return this.journal == null ? Optional.empty() : Optional.of(this.journal);
    }

    public Optional<String> getArticleNumber() {
        return this.articleNumber == null ? Optional.empty() : Optional.of(this.articleNumber);
    }
}

