/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.transformers;

import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.lucene.queryparser.flexible.core.nodes.BooleanQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.GroupQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.ModifierQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.OrQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueryTransformer {
    public static final String NO_EXPLICIT_FIELD = "default";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQueryTransformer.class);
    protected int startYear = Integer.MAX_VALUE;
    protected int endYear = Integer.MIN_VALUE;

    protected Optional<String> transform(BooleanQueryNode query) {
        String delimiter = query instanceof OrQueryNode ? this.getLogicalOrOperator() : this.getLogicalAndOperator();
        String result = query.getChildren().stream().map(this::transform).flatMap(Optional::stream).collect(Collectors.joining(delimiter, "(", ")"));
        if ("()".equals(result)) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    protected abstract String getLogicalAndOperator();

    protected abstract String getLogicalOrOperator();

    protected abstract String getLogicalNotOperator();

    private Optional<String> transform(FieldQueryNode query) {
        String term = query.getTextAsString();
        switch (query.getFieldAsString()) {
            case "author": {
                return Optional.of(this.handleAuthor(term));
            }
            case "title": {
                return Optional.of(this.handleTitle(term));
            }
            case "journal": {
                return Optional.of(this.handleJournal(term));
            }
            case "year": {
                String s = this.handleYear(term);
                return s.isEmpty() ? Optional.empty() : Optional.of(s);
            }
            case "year-range": {
                String s = this.handleYearRange(term);
                return s.isEmpty() ? Optional.empty() : Optional.of(s);
            }
            case "doi": {
                String s = this.handleDoi(term);
                return s.isEmpty() ? Optional.empty() : Optional.of(s);
            }
            case "default": {
                return this.handleUnFieldedTerm(term);
            }
        }
        return this.handleOtherField(query.getFieldAsString(), term);
    }

    protected String handleDoi(String term) {
        return "doi:" + term;
    }

    private Optional<String> transform(ModifierQueryNode query) {
        ModifierQueryNode.Modifier modifier = query.getModifier();
        if (modifier == ModifierQueryNode.Modifier.MOD_NOT) {
            return this.transform(query.getChild()).map(s -> this.getLogicalNotOperator() + s);
        }
        return this.transform(query.getChild());
    }

    protected abstract String handleAuthor(String var1);

    protected abstract String handleTitle(String var1);

    protected abstract String handleJournal(String var1);

    protected abstract String handleYear(String var1);

    protected void parseYearRange(String yearRange) {
        int parsedStartYear;
        String[] split = yearRange.split("-");
        this.startYear = parsedStartYear = Integer.parseInt(split[0]);
        int parsedEndYear = Integer.parseInt(split[1]);
        if (parsedEndYear >= parsedStartYear) {
            this.endYear = parsedEndYear;
        } else {
            this.startYear = parsedEndYear;
            this.endYear = parsedStartYear;
        }
    }

    protected String handleYearRange(String yearRange) {
        this.parseYearRange(yearRange);
        if (this.endYear == Integer.MAX_VALUE) {
            return yearRange;
        }
        StringJoiner resultBuilder = new StringJoiner(this.getLogicalOrOperator());
        for (int i = this.startYear; i <= this.endYear; ++i) {
            resultBuilder.add(this.handleYear(String.valueOf(i)));
        }
        return resultBuilder.toString();
    }

    protected Optional<String> handleUnFieldedTerm(String term) {
        return Optional.of(StringUtil.quoteStringIfSpaceIsContained(term));
    }

    protected String createKeyValuePair(String fieldAsString, String term) {
        return this.createKeyValuePair(fieldAsString, term, ":");
    }

    protected String createKeyValuePair(String fieldAsString, String term, String separator) {
        return "%s%s%s".formatted(fieldAsString, separator, StringUtil.quoteStringIfSpaceIsContained(term));
    }

    protected Optional<String> handleOtherField(String fieldAsString, String term) {
        return Optional.of(this.createKeyValuePair(fieldAsString, term));
    }

    protected Optional<String> transform(QueryNode query) {
        QueryNode queryNode = query;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanQueryNode.class, FieldQueryNode.class, GroupQueryNode.class, ModifierQueryNode.class}, (Object)queryNode, n)) {
            case 0: {
                BooleanQueryNode booleanQueryNode = (BooleanQueryNode)queryNode;
                return this.transform(booleanQueryNode);
            }
            case 1: {
                FieldQueryNode fieldQueryNode = (FieldQueryNode)queryNode;
                return this.transform(fieldQueryNode);
            }
            case 2: {
                GroupQueryNode groupQueryNode = (GroupQueryNode)queryNode;
                return this.transform(groupQueryNode.getChild());
            }
            case 3: {
                ModifierQueryNode modifierQueryNode = (ModifierQueryNode)queryNode;
                return this.transform(modifierQueryNode);
            }
        }
        LOGGER.error("Unsupported case when transforming the query:\n {}", (Object)query);
        return Optional.empty();
    }

    public Optional<String> transformLuceneQuery(QueryNode luceneQuery) {
        Optional<String> transformedQuery = this.transform(luceneQuery);
        transformedQuery = transformedQuery.map(this::removeOuterBraces);
        return transformedQuery;
    }

    private String removeOuterBraces(String query) {
        if (query.startsWith("(") && query.endsWith(")")) {
            return query.substring(1, query.length() - 1);
        }
        return query;
    }
}

