/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kong.unirest.core.GetRequest;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.JsonNode;
import kong.unirest.core.Unirest;
import kong.unirest.core.UnirestException;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.fetcher.CustomizableKeyFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.logic.util.BuildInfo;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScienceDirect
implements FulltextFetcher,
CustomizableKeyFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScienceDirect.class);
    private static final String API_URL = "https://api.elsevier.com/content/article/doi/";
    private static final String API_KEY = new BuildInfo().scienceDirectApiKey;
    private static final String FETCHER_NAME = "ScienceDirect";
    private final ImporterPreferences importerPreferences;

    public ScienceDirect(ImporterPreferences importerPreferences) {
        this.importerPreferences = importerPreferences;
    }

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        String fullLinkToPdf;
        Objects.requireNonNull(entry);
        Optional doi = entry.getField(StandardField.DOI).flatMap(DOI::parse);
        if (doi.isEmpty()) {
            return Optional.empty();
        }
        String urlFromDoi = this.getUrlByDoi(((DOI)doi.get()).getDOI());
        if (urlFromDoi.isEmpty()) {
            return Optional.empty();
        }
        Document html = Jsoup.connect((String)urlFromDoi).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36").referrer("https://www.google.com").ignoreHttpErrors(true).get();
        Elements metaLinks = html.getElementsByAttributeValue("name", "citation_pdf_url");
        if (!metaLinks.isEmpty()) {
            String link = metaLinks.first().attr("content");
            return Optional.of(new URL(link));
        }
        Optional<JSONObject> pdfDownloadOptional = html.getElementsByAttributeValue("type", "application/json").stream().flatMap(element -> element.getElementsByTag("script").stream()).map(element -> element.childNode(0)).map(Node::toString).map(JSONObject::new).filter(json -> json.has("article")).map(json -> json.getJSONObject("article")).filter(json -> json.has("pdfDownload")).map(json -> json.getJSONObject("pdfDownload")).findAny();
        if (pdfDownloadOptional.isEmpty()) {
            LOGGER.debug("No 'pdfDownload' key found in JSON information");
            return Optional.empty();
        }
        JSONObject pdfDownload = pdfDownloadOptional.get();
        if (pdfDownload.has("linkToPdf")) {
            String linkToPdf = pdfDownload.getString("linkToPdf");
            URL url = new URL(urlFromDoi);
            fullLinkToPdf = "%s://%s%s".formatted(url.getProtocol(), url.getAuthority(), linkToPdf);
        } else if (pdfDownload.has("urlMetadata")) {
            JSONObject urlMetadata = pdfDownload.getJSONObject("urlMetadata");
            JSONObject queryParamsObject = urlMetadata.getJSONObject("queryParams");
            String queryParameters = queryParamsObject.keySet().stream().map(key -> "%s=%s".formatted(key, queryParamsObject.getString(key))).collect(Collectors.joining("&"));
            fullLinkToPdf = "https://www.sciencedirect.com/%s/%s%s?%s".formatted(urlMetadata.getString("path"), urlMetadata.getString("pii"), urlMetadata.getString("pdfExtension"), queryParameters);
        } else {
            LOGGER.debug("No suitable data in JSON information");
            return Optional.empty();
        }
        LOGGER.info("Fulltext PDF found at ScienceDirect at {}.", (Object)fullLinkToPdf);
        try {
            return Optional.of(new URL(fullLinkToPdf));
        }
        catch (MalformedURLException e) {
            LOGGER.error("malformed URL", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.PUBLISHER;
    }

    private String getUrlByDoi(String doi) throws UnirestException {
        String sciLink = "";
        try {
            String request = API_URL + doi;
            HttpResponse jsonResponse = ((GetRequest)((GetRequest)Unirest.get((String)request).header("X-ELS-APIKey", this.importerPreferences.getApiKey(this.getName()).orElse(API_KEY))).queryString("httpAccept", (Object)"application/json")).asJson();
            JSONObject json = ((JsonNode)jsonResponse.getBody()).getObject();
            JSONArray links = json.getJSONObject("full-text-retrieval-response").getJSONObject("coredata").getJSONArray("link");
            for (int i = 0; i < links.length(); ++i) {
                JSONObject link = links.getJSONObject(i);
                if (!"scidir".equals(link.getString("@rel"))) continue;
                sciLink = link.getString("@href");
            }
            return sciLink;
        }
        catch (JSONException e) {
            LOGGER.debug("No ScienceDirect link found in API request", (Throwable)e);
            return sciLink;
        }
    }

    @Override
    public String getName() {
        return FETCHER_NAME;
    }
}

