/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.Optional;
import org.apache.hc.core5.net.URIBuilder;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedParserFetcher;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.fileformat.BibtexParser;

public class RfcFetcher
implements IdBasedParserFetcher {
    private static final String DRAFT_PREFIX = "draft";
    private final ImportFormatPreferences importFormatPreferences;

    public RfcFetcher(ImportFormatPreferences importFormatPreferences) {
        this.importFormatPreferences = importFormatPreferences;
    }

    @Override
    public String getName() {
        return "RFC";
    }

    @Override
    public Optional<HelpFile> getHelpPage() {
        return Optional.of(HelpFile.FETCHER_RFC);
    }

    @Override
    public URL getUrlForIdentifier(String identifier) throws URISyntaxException, MalformedURLException, FetcherException {
        Object prefixedIdentifier = identifier.toLowerCase(Locale.ENGLISH);
        if (!((String)prefixedIdentifier).startsWith(DRAFT_PREFIX) && !((String)prefixedIdentifier).startsWith("rfc")) {
            prefixedIdentifier = "rfc" + (String)prefixedIdentifier;
        }
        URIBuilder uriBuilder = new URIBuilder("https://datatracker.ietf.org/doc/" + (String)prefixedIdentifier + "/bibtex/");
        return uriBuilder.build().toURL();
    }

    @Override
    public Parser getParser() {
        return new BibtexParser(this.importFormatPreferences);
    }
}

