/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kong.unirest.core.JsonNode;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.cleanup.DoiCleanup;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.cleanup.MoveFieldCleanup;
import org.jabref.logic.formatter.bibtexfields.ClearFormatter;
import org.jabref.logic.importer.EntryBasedParserFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedParserFetcher;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.SearchBasedParserFetcher;
import org.jabref.logic.importer.fetcher.transformers.DefaultQueryTransformer;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.AMSField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.util.DummyFileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathSciNet
implements SearchBasedParserFetcher,
EntryBasedParserFetcher,
IdBasedParserFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MathSciNet.class);
    private static final Map<StandardField, List<String>> FIELD_MAPPINGS = Map.of(StandardField.TITLE, List.of("titles", "title"), StandardField.YEAR, List.of("issue", "issue", "pubYear"), StandardField.JOURNAL, List.of("issue", "issue", "journal", "shortTitle"), StandardField.VOLUME, List.of("issue", "issue", "volume"), StandardField.NUMBER, List.of("issue", "issue", "number"), StandardField.PAGES, List.of("paging", "paging", "text"), StandardField.ISSN, List.of("issue", "issue", "journal", "issn"));
    private final ImportFormatPreferences preferences;

    public MathSciNet(ImportFormatPreferences preferences) {
        this.preferences = Objects.requireNonNull(preferences);
    }

    @Override
    public String getName() {
        return "MathSciNet";
    }

    @Override
    public URL getURLForEntry(BibEntry entry) throws URISyntaxException, MalformedURLException, FetcherException {
        Optional<String> mrNumberInEntry = entry.getField(StandardField.MR_NUMBER);
        if (mrNumberInEntry.isPresent()) {
            return this.getUrlForIdentifier(mrNumberInEntry.get());
        }
        URIBuilder uriBuilder = new URIBuilder("https://mathscinet.ams.org/mathscinet/api/freetools/mrlookup");
        uriBuilder.addParameter("author", entry.getFieldOrAlias(StandardField.AUTHOR).orElse(""));
        uriBuilder.addParameter("title", entry.getFieldOrAlias(StandardField.TITLE).orElse(""));
        uriBuilder.addParameter("journal", entry.getFieldOrAlias(StandardField.JOURNAL).orElse(""));
        uriBuilder.addParameter("year", entry.getFieldOrAlias(StandardField.YEAR).orElse(""));
        uriBuilder.addParameter("firstPage", "");
        uriBuilder.addParameter("lastPage", "");
        return uriBuilder.build().toURL();
    }

    @Override
    public URL getURLForQuery(QueryNode luceneQuery) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder("https://mathscinet.ams.org/mathscinet/api/publications/search");
        uriBuilder.addParameter("query", new DefaultQueryTransformer().transformLuceneQuery(luceneQuery).orElse(""));
        uriBuilder.addParameter("currentPage", "1");
        uriBuilder.addParameter("pageSize", "100");
        return uriBuilder.build().toURL();
    }

    @Override
    public URL getUrlForIdentifier(String identifier) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder("https://mathscinet.ams.org/mathscinet/api/publications/format");
        uriBuilder.addParameter("formats", "bib");
        uriBuilder.addParameter("ids", identifier);
        return uriBuilder.build().toURL();
    }

    @Override
    public Parser getParser() {
        return inputStream -> {
            String response = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(OS.NEWLINE));
            ArrayList<BibEntry> entries = new ArrayList<BibEntry>();
            BibtexParser bibtexParser = new BibtexParser(this.preferences, new DummyFileUpdateMonitor());
            try {
                JsonNode node = new JsonNode(response);
                if (node.isArray()) {
                    JSONArray entriesArray = node.getArray();
                    for (int i = 0; i < entriesArray.length(); ++i) {
                        JSONObject entryObject = entriesArray.getJSONObject(i);
                        if (!entryObject.has("bib")) continue;
                        String bibTexFormat = entriesArray.getJSONObject(i).getString("bib");
                        entries.addAll(bibtexParser.parseEntries(bibTexFormat));
                    }
                } else {
                    JSONObject element = node.getObject();
                    if (element.has("all")) {
                        JSONArray entriesArray = element.getJSONObject("all").getJSONArray("results");
                        for (int i = 0; i < entriesArray.length(); ++i) {
                            String bibTexFormat = entriesArray.getJSONObject(i).getString("bibTexFormat");
                            entries.addAll(bibtexParser.parseEntries(bibTexFormat));
                        }
                    } else if (element.has("results")) {
                        JSONArray entriesArray = element.getJSONArray("results");
                        for (int i = 0; i < entriesArray.length(); ++i) {
                            JSONObject entryObject = entriesArray.getJSONObject(i);
                            BibEntry bibEntry = this.jsonItemToBibEntry(entryObject);
                            entries.add(bibEntry);
                        }
                    }
                }
            }
            catch (JSONException | ParseException e) {
                LOGGER.error("An error occurred while parsing fetched data", e);
                throw new ParseException("Error when parsing entry", e);
            }
            return entries;
        };
    }

    private BibEntry jsonItemToBibEntry(JSONObject item) throws ParseException {
        try {
            String mrNumber;
            BibEntry entry = new BibEntry(StandardEntryType.Article);
            Optional<String> authors = this.toAuthors(item.optJSONArray("authors"));
            authors.ifPresent(value -> entry.setField(StandardField.AUTHOR, (String)value));
            Optional<String> keywords = this.getKeywords(item.optJSONObject("primaryClass"));
            keywords.ifPresent(value -> entry.setField(StandardField.KEYWORDS, (String)value));
            for (Map.Entry<StandardField, List<String>> mapEntry : FIELD_MAPPINGS.entrySet()) {
                StandardField field = mapEntry.getKey();
                List<String> path = mapEntry.getValue();
                Optional<String> value2 = this.getOthers(item, path);
                value2.ifPresent(v -> entry.setField(field, (String)v));
            }
            String doi = item.optString("articleUrl");
            if (!doi.isEmpty()) {
                try {
                    DOI.parse(doi).ifPresent(validDoi -> entry.setField(StandardField.DOI, validDoi.getNormalized()));
                }
                catch (IllegalArgumentException e) {
                    entry.setField(StandardField.DOI, doi);
                }
            }
            if (!(mrNumber = item.optString("mrnumber")).isEmpty()) {
                entry.setField(StandardField.MR_NUMBER, mrNumber);
            }
            return entry;
        }
        catch (JSONException exception) {
            throw new ParseException("MathSciNet API JSON format has changed", exception);
        }
    }

    private Optional<String> toAuthors(JSONArray authors) {
        if (authors == null) {
            return Optional.empty();
        }
        String authorsString = IntStream.range(0, authors.length()).mapToObj(arg_0 -> ((JSONArray)authors).getJSONObject(arg_0)).map(author -> {
            String name = author.optString("name", "");
            return this.fixStringEncoding(name);
        }).collect(Collectors.joining(" and "));
        return Optional.of(authorsString);
    }

    private Optional<String> getKeywords(JSONObject primaryClass) {
        if (primaryClass == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(primaryClass.optString("description", null));
    }

    private Optional<String> getOthers(JSONObject item, List<String> keys) {
        Object value = item;
        for (String key : keys) {
            if (value instanceof JSONObject) {
                JSONObject obj = value;
                value = obj.opt(key);
                continue;
            }
            if (!(value instanceof JSONArray)) break;
            JSONArray arr = (JSONArray)value;
            value = arr.opt(Integer.parseInt(key));
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return Optional.of(this.fixStringEncoding(stringValue));
        }
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return Optional.of(intValue.toString());
        }
        return Optional.empty();
    }

    private String fixStringEncoding(String value) {
        return new String(value.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
    }

    @Override
    public void doPostCleanup(BibEntry entry) {
        new MoveFieldCleanup(AMSField.FJOURNAL, StandardField.JOURNAL).cleanup(entry);
        new MoveFieldCleanup(new UnknownField("mrclass"), StandardField.KEYWORDS).cleanup(entry);
        new FieldFormatterCleanup(new UnknownField("mrreviewer"), new ClearFormatter()).cleanup(entry);
        new DoiCleanup().cleanup(entry);
        new FieldFormatterCleanup(StandardField.URL, new ClearFormatter()).cleanup(entry);
        entry.setCommentsBeforeEntry("");
    }
}

