/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringJoiner;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.SearchBasedParserFetcher;
import org.jabref.logic.importer.fetcher.transformers.DefaultQueryTransformer;
import org.jabref.logic.importer.util.JsonReader;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.StringUtil;

public class DOABFetcher
implements SearchBasedParserFetcher {
    private static final String SEARCH_URL = "https://directory.doabooks.org/rest/search?";

    @Override
    public String getName() {
        return "DOAB";
    }

    @Override
    public URL getURLForQuery(QueryNode luceneQuery) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder builder = new URIBuilder(SEARCH_URL);
        String query = new DefaultQueryTransformer().transformLuceneQuery(luceneQuery).orElse("");
        query = "\"".concat(query).concat("\"");
        builder.addParameter("query", query);
        builder.addParameter("expand", "metadata,bitstreams");
        return builder.build().toURL();
    }

    @Override
    public Parser getParser() {
        return InputStream2 -> {
            JSONArray response = JsonReader.toJsonArray(InputStream2);
            if (response.isEmpty()) {
                return Collections.emptyList();
            }
            if (response.length() == 1) {
                JSONArray metadataArray = response.getJSONObject(0).getJSONArray("metadata");
                JSONArray bitstreamArray = response.getJSONObject(0).getJSONArray("bitstreams");
                BibEntry entry = this.jsonToBibEntry(metadataArray, bitstreamArray);
                return Collections.singletonList(entry);
            }
            ArrayList<BibEntry> entries = new ArrayList<BibEntry>(response.length());
            for (int i = 0; i < response.length(); ++i) {
                JSONArray metadataArray = response.getJSONObject(i).getJSONArray("metadata");
                JSONArray bitstreamArray = response.getJSONObject(i).getJSONArray("bitstreams");
                BibEntry entry = this.jsonToBibEntry(metadataArray, bitstreamArray);
                entries.add(entry);
            }
            return entries;
        };
    }

    private BibEntry jsonToBibEntry(JSONArray metadataArray, JSONArray bitstreamArray) {
        int i;
        BibEntry entry = new BibEntry();
        ArrayList<Author> authorsList = new ArrayList<Author>();
        ArrayList<Author> editorsList = new ArrayList<Author>();
        StringJoiner keywordJoiner = new StringJoiner(", ");
        String publisherImprint = "";
        for (i = 0; i < bitstreamArray.length(); ++i) {
            JSONObject bitstreamObject = bitstreamArray.getJSONObject(i);
            JSONArray array = bitstreamObject.getJSONArray("metadata");
            for (int k = 0; k < array.length(); ++k) {
                JSONObject metadataInBitstreamObject = array.getJSONObject(k);
                if ("dc.identifier.isbn".equals(metadataInBitstreamObject.getString("key"))) {
                    entry.setField(StandardField.ISBN, metadataInBitstreamObject.getString("value"));
                    continue;
                }
                if (!"oapen.relation.isbn".equals(metadataInBitstreamObject.getString("key"))) continue;
                entry.setField(StandardField.ISBN, metadataInBitstreamObject.getString("value"));
            }
        }
        block43: for (i = 0; i < metadataArray.length(); ++i) {
            JSONObject dataObject = metadataArray.getJSONObject(i);
            switch (dataObject.getString("key")) {
                case "dc.contributor.author": {
                    if (dataObject.getString("value").contains("(Ed.)")) {
                        editorsList.add(this.toAuthor(this.namePreprocessing(dataObject.getString("value"))));
                        continue block43;
                    }
                    authorsList.add(this.toAuthor(dataObject.getString("value")));
                    continue block43;
                }
                case "dc.type": {
                    entry.setType(StandardEntryType.Book);
                    continue block43;
                }
                case "dc.date.issued": {
                    entry.setField(StandardField.DATE, dataObject.getString("value"));
                    continue block43;
                }
                case "oapen.identifier.doi": {
                    entry.setField(StandardField.DOI, dataObject.getString("value"));
                    continue block43;
                }
                case "dc.title": {
                    entry.setField(StandardField.TITLE, dataObject.getString("value"));
                    continue block43;
                }
                case "oapen.pages": {
                    try {
                        entry.setField(StandardField.PAGES, String.valueOf(dataObject.getInt("value")));
                    }
                    catch (JSONException e) {
                        entry.setField(StandardField.PAGES, dataObject.getString("value"));
                    }
                    continue block43;
                }
                case "dc.description.abstract": {
                    entry.setField(StandardField.ABSTRACT, dataObject.getString("value"));
                    continue block43;
                }
                case "dc.language": {
                    entry.setField(StandardField.LANGUAGE, dataObject.getString("value"));
                    continue block43;
                }
                case "publisher.name": {
                    entry.setField(StandardField.PUBLISHER, dataObject.getString("value"));
                    continue block43;
                }
                case "dc.identifier.uri": {
                    entry.setField(StandardField.URI, dataObject.getString("value"));
                    continue block43;
                }
                case "dc.identifier": {
                    if (!dataObject.getString("value").contains("http")) continue block43;
                    entry.setField(StandardField.URL, dataObject.getString("value"));
                    continue block43;
                }
                case "dc.subject.other": {
                    keywordJoiner.add(dataObject.getString("value"));
                    continue block43;
                }
                case "dc.contributor.editor": {
                    editorsList.add(this.toAuthor(dataObject.getString("value")));
                    continue block43;
                }
                case "oapen.volume": {
                    entry.setField(StandardField.VOLUME, dataObject.getString("value"));
                    continue block43;
                }
                case "oapen.relation.isbn": 
                case "dc.identifier.isbn": {
                    entry.setField(StandardField.ISBN, dataObject.getString("value"));
                    continue block43;
                }
                case "dc.title.alternative": {
                    entry.setField(StandardField.SUBTITLE, dataObject.getString("value"));
                    continue block43;
                }
                case "oapen.imprint": {
                    publisherImprint = dataObject.getString("value");
                }
            }
        }
        entry.setField(StandardField.AUTHOR, AuthorList.of(authorsList).getAsFirstLastNamesWithAnd());
        entry.setField(StandardField.EDITOR, AuthorList.of(editorsList).getAsFirstLastNamesWithAnd());
        entry.setField(StandardField.KEYWORDS, String.valueOf(keywordJoiner));
        if (entry.getField(StandardField.PUBLISHER).isEmpty() && !StringUtil.isNullOrEmpty(publisherImprint)) {
            entry.setField(StandardField.PUBLISHER, publisherImprint);
        }
        return entry;
    }

    private Author toAuthor(String author) {
        return AuthorList.parse(author).getAuthor(0);
    }

    private String namePreprocessing(String name) {
        return name.replace("(Ed.)", "");
    }
}

