/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACS
implements FulltextFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ACS.class);
    private static final String SOURCE = "https://pubs.acs.org/doi/abs/%s";

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        Objects.requireNonNull(entry);
        Optional doi = entry.getField(StandardField.DOI).flatMap(DOI::parse);
        if (!doi.isPresent()) {
            return Optional.empty();
        }
        String source = SOURCE.formatted(((DOI)doi.get()).getDOI());
        Document html = Jsoup.connect((String)source).ignoreHttpErrors(true).get();
        Element link = html.select("a.button_primary").first();
        if (link != null) {
            LOGGER.info("Fulltext PDF found @ ACS.");
            return Optional.of(new URL(source.replaceFirst("/abs/", "/pdf/")));
        }
        return Optional.empty();
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.PUBLISHER;
    }
}

