/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.queryparser.flexible.core.QueryNodeParseException;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.standard.parser.StandardSyntaxParser;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.SearchBasedFetcher;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.paging.Page;

public interface PagedSearchBasedFetcher
extends SearchBasedFetcher {
    public Page<BibEntry> performSearchPaged(QueryNode var1, int var2) throws FetcherException;

    default public Page<BibEntry> performSearchPaged(String searchQuery, int pageNumber) throws FetcherException {
        if (searchQuery.isBlank()) {
            return new Page<BibEntry>(searchQuery, pageNumber, Collections.emptyList());
        }
        StandardSyntaxParser parser = new StandardSyntaxParser();
        String NO_EXPLICIT_FIELD = "default";
        try {
            return this.performSearchPaged(parser.parse((CharSequence)searchQuery, (CharSequence)"default"), pageNumber);
        }
        catch (QueryNodeParseException e) {
            throw new FetcherException("An error occurred during parsing of the query.");
        }
    }

    default public int getPageSize() {
        return 20;
    }

    @Override
    default public List<BibEntry> performSearch(QueryNode luceneQuery) throws FetcherException {
        return new ArrayList<BibEntry>(this.performSearchPaged(luceneQuery, 0).getContent());
    }
}

