/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdFetcher;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.ParserFetcher;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.identifier.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IdParserFetcher<T extends Identifier>
extends IdFetcher<T>,
ParserFetcher {
    public static final Logger LOGGER = LoggerFactory.getLogger(IdParserFetcher.class);

    public URL getURLForEntry(BibEntry var1) throws URISyntaxException, MalformedURLException, FetcherException;

    public Parser getParser();

    public Optional<T> extractIdentifier(BibEntry var1, List<BibEntry> var2) throws FetcherException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public Optional<T> findIdentifier(BibEntry entry) throws FetcherException {
        Objects.requireNonNull(entry);
        try (BufferedInputStream stream = new BufferedInputStream(this.getURLForEntry(entry).openStream());){
            List<BibEntry> fetchedEntries222 = this.getParser().parseEntries(stream);
            if (fetchedEntries222.isEmpty()) {
                Optional optional = Optional.empty();
                return optional;
            }
            fetchedEntries222.forEach(this::doPostCleanup);
            Optional<T> throwable = this.extractIdentifier(entry, fetchedEntries222);
            return throwable;
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Id not found");
            return Optional.empty();
        }
        catch (IOException e) {
            Throwable throwable = e.getCause();
            if (!(throwable instanceof FetcherException)) throw new FetcherException("An I/O exception occurred", e);
            FetcherException fe = (FetcherException)throwable;
            throw fe;
        }
        catch (ParseException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
    }
}

