/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.ParserFetcher;
import org.jabref.model.entry.BibEntry;

public interface EntryBasedParserFetcher
extends EntryBasedFetcher,
ParserFetcher {
    public URL getURLForEntry(BibEntry var1) throws URISyntaxException, MalformedURLException, FetcherException;

    public Parser getParser();

    @Override
    default public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
        List<BibEntry> list;
        URL UrlForEntry;
        Objects.requireNonNull(entry);
        try {
            UrlForEntry = this.getURLForEntry(entry);
            if (UrlForEntry == null) {
                return Collections.emptyList();
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        BufferedInputStream stream = new BufferedInputStream(UrlForEntry.openStream());
        try {
            List<BibEntry> fetchedEntries = this.getParser().parseEntries(stream);
            fetchedEntries.forEach(this::doPostCleanup);
            list = fetchedEntries;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FetcherException("A network error occurred", e);
            }
            catch (ParseException e) {
                throw new FetcherException("An internal parser error occurred", e);
            }
        }
        ((InputStream)stream).close();
        return list;
    }
}

