/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class Word {
    public static final Set<String> SMALLER_WORDS;
    public static final Set<Character> DASHES;
    public static final Set<String> CONJUNCTIONS;
    private final char[] chars;
    private final boolean[] protectedChars;

    public Word(char[] chars, boolean[] protectedChars) {
        this.chars = Objects.requireNonNull(chars);
        this.protectedChars = Objects.requireNonNull(protectedChars);
        if (this.chars.length != this.protectedChars.length) {
            throw new IllegalArgumentException("the chars and the protectedChars array must be of same length");
        }
    }

    public static boolean isSmallerWord(String word) {
        return SMALLER_WORDS.contains(word.toLowerCase(Locale.ROOT));
    }

    public void toUpperCase() {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.protectedChars[i]) continue;
            this.chars[i] = Character.toUpperCase(this.chars[i]);
        }
    }

    public void toLowerCase() {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.protectedChars[i]) continue;
            this.chars[i] = Character.toLowerCase(this.chars[i]);
        }
    }

    public void toUpperFirst() {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.protectedChars[i]) continue;
            this.chars[i] = i == 0 ? Character.toUpperCase(this.chars[i]) : Character.toLowerCase(this.chars[i]);
        }
    }

    public void toUpperFirstIgnoreHyphen() {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.protectedChars[i]) continue;
            this.chars[i] = i == 0 || DASHES.contains(Character.valueOf(this.chars[i - 1])) ? Character.toUpperCase(this.chars[i]) : Character.toLowerCase(this.chars[i]);
        }
    }

    public void toUpperFirstTitle() {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.protectedChars[i]) continue;
            this.chars[i] = i == 0 || DASHES.contains(Character.valueOf(this.chars[i - 1])) && this.isConjunction(this.chars, i) ? Character.toUpperCase(this.chars[i]) : Character.toLowerCase(this.chars[i]);
        }
    }

    private boolean isConjunction(char[] chars, int i) {
        Object word = "";
        while (i < chars.length && !DASHES.contains(Character.valueOf(chars[i]))) {
            word = (String)word + chars[i];
            ++i;
        }
        return !CONJUNCTIONS.contains(word);
    }

    public void stripConsonants() {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.protectedChars[i]) continue;
            this.chars[i] = i == 0 || DASHES.contains(Character.valueOf(this.chars[i - 1])) ? Character.toUpperCase(this.chars[i]) : Character.toLowerCase(this.chars[i]);
        }
    }

    public boolean isSmallerWord() {
        return SMALLER_WORDS.contains(this.toString().replace(":", "").toLowerCase(Locale.ROOT));
    }

    public boolean isLargerWord() {
        return !this.isSmallerWord();
    }

    public String toString() {
        return new String(this.chars);
    }

    public boolean endsWithColon() {
        return this.toString().endsWith(":");
    }

    static {
        DASHES = Set.of(Character.valueOf('-'), Character.valueOf('~'), Character.valueOf('\u2e17'), Character.valueOf('\u3030'), Character.valueOf('\u1400'), Character.valueOf('\u058a'), Character.valueOf('\u05be'), Character.valueOf('\u2010'), Character.valueOf('\u2011'), Character.valueOf('\u2012'), Character.valueOf('\u2013'), Character.valueOf('\u2014'), Character.valueOf('\u2015'), Character.valueOf('\u2053'), Character.valueOf('\u207b'), Character.valueOf('\u208b'), Character.valueOf('\u2212'), Character.valueOf('\u2e3a'), Character.valueOf('\u2e3b'), Character.valueOf('\u301c'), Character.valueOf('\u30a0'), Character.valueOf('\ufe31'), Character.valueOf('\ufe32'), Character.valueOf('\ufe58'), Character.valueOf('\ufe63'), Character.valueOf('\uff0d'));
        CONJUNCTIONS = Set.of("and", "but", "for", "nor", "or", "so", "yet");
        HashSet<String> smallerWords = new HashSet<String>();
        smallerWords.addAll(Arrays.asList("a", "an", "the"));
        smallerWords.addAll(Arrays.asList("above", "about", "across", "against", "along", "among", "around", "at", "before", "behind", "below", "beneath", "beside", "between", "beyond", "by", "down", "during", "except", "for", "from", "in", "inside", "into", "like", "near", "of", "off", "on", "onto", "since", "to", "toward", "through", "under", "until", "up", "upon", "with", "within", "without"));
        smallerWords.addAll(CONJUNCTIONS);
        SMALLER_WORDS = smallerWords.stream().map(word -> word.toLowerCase(Locale.ROOT)).collect(Collectors.toUnmodifiableSet());
    }
}

