/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.casechanger.Title;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.l10n.Localization;

public class UpperCaseFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("UPPER CASE", new Object[0]);
    }

    @Override
    public String getKey() {
        return "upper_case";
    }

    @Override
    public String format(String input) {
        Title title = new Title(input);
        title.getWords().stream().forEach(Word::toUpperCase);
        return title.toString();
    }

    @Override
    public String getDescription() {
        return Localization.lang("CHANGES ALL LETTERS TO UPPER CASE.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "Kde {Amarok}";
    }
}

